<?php
require_once("prefobj.php");

class globalpref extends prefobj {
	var $prefix = "gp";
	var $focus = "username";

	function html_editEntry($config) {
		$html = "<h2>" . _("Global preferences") . "</h2>\n";
		$html .= "<div class='status' id='status'></div>\n";
		$html .= "<form id='pref' name='pref' action='#' onsubmit='xajax_" . $this->prefix . "_save(xajax.getFormValues(\"pref\"));return false'>\n";
		$html .= "<div class='editlabel'>" . _("Language") . ":</div>";
		$html .= "<select class='editpref' name='LC_ALL'>\n";
		$languages = array("en_US.UTF-8" => _("English"),
					"de_DE.UTF-8" => _("German"));
		foreach($languages as $locale => $language)
			$html .= sprintf("<option value='%s'%s>%s</option>",
					$locale, ($config['LC_ALL'] == $locale) ? " selected":"", $language);
		$html .= "</select><br/>\n";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "</form>\n";

		return $html;
	}
}

?>
