<?php
require_once("listobj.php");

class grouplist extends listobj {
	var $prefix = "glist";
	var $tablename = "groups";
	var $focus = "groupname";

	function html_listheader() {
		$html  = "<tr class='header'><th>" . _("Groupname");
		$html .= "</th><th></th></tr>\n";
		$html .= "<tr id='row0'><td colspan='5'><a onclick='xajax_" . $this->prefix . "_editEntry(0);return false' href='#'>" . _("New entry") . "</a></td></tr>\n";
		
		return $html;
	}

	function html_editEntry($entry) {
		$gid = (int)$entry['id'];

		$result = pg_query("SELECT * FROM users WHERE id IN (SELECT uid FROM group_user WHERE gid = '$gid') ORDER BY username");
		$members = pg_fetch_all($result);
		$result = pg_query("SELECT * FROM users WHERE id NOT IN (SELECT uid FROM group_user WHERE gid = '$gid') ORDER BY username");
		$notmembers = pg_fetch_all($result);

		$html  = "<td colspan='3'><form id='editform$gid' name='editform' action='#' onsubmit='select_options(\"members\");xajax_" . $this->prefix . "_saveEntry(xajax.getFormValues(\"editform$gid\")); return false'>\n";
		$html .= "<input type='hidden' name='id' value='$gid'/>";
		$html .= "<div class='editlabel'>" . _("Groupname") . ":</div>";
		$html .= "<input class='editgroupname' type='text' id='groupname' name='groupname' value='" . $entry['groupname'] . "'/><br/>\n";
		$html .= "<select class='msleft' name='notmembers' id='notmembers' size='10' multiple='multiple'>";
		if($notmembers)
			foreach($notmembers as $user)
				$html .= sprintf("<option value='%s' id='notmembers%s'>%s</option>", $user['id'], $user['id'], $user['username']);
		$html .= "</select>\n";
		$html .= "<select class='msright' name='members' id='members' size='10' multiple='multiple'>";
		if($members)
			foreach($members as $user)
				$html .= sprintf("<option value='%s' id='members%s'>%s</option>", $user['id'], $user['id'], $user['username']);
		$html .= "</select>\n";
		$html .= "<div class='morelessbuttons'>";
		$html .= "<input type='button' value='&gt;&gt;' onclick='xajax_select_move(get_options(\"notmembers\", \"all\"), \"notmembers\", \"members\")'/><br/>\n";
		$html .= "<input type='button' value='&gt;' onclick='xajax_select_move(get_options(\"notmembers\", \"selected\"), \"notmembers\", \"members\")'/><br/>\n";
		$html .= "<input type='button' value='&lt;' onclick='xajax_select_move(get_options(\"members\", \"selected\"), \"members\", \"notmembers\")'/><br/>\n";
		$html .= "<input type='button' value='&lt;&lt;' onclick='xajax_select_move(get_options(\"members\", \"all\"), \"members\", \"notmembers\")'/><br/>\n";
		$html .= "</div>";
		$html .= "<div class='editbuttons'>";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "<input type='button' value='" . _("Back") . "' onclick='xajax_" . $this->prefix . "_search(document.getElementById(\"searchbox\").value)'/>\n";
		$html .= "<input type='button' value='" . _("Delete entry") . "' onclick='xajax_" . $this->prefix . "_deleteEntry($id,document.getElementById(\"searchbox\").value)'/>";
		$html .= "</div></form></td>";

		return $html;
	}

	function html_row($row) {
		$html = sprintf("<td>%s</td>",
				 $row['groupname']);
		$html .= "<td><a href='#' onclick='xajax_" . $this->prefix . "_editEntry(" . $row['id'] . "); return false;'>E</a></td>";

		return $html;
	}

	/*
	function get_selectquery($id) {
		$query = "SELECT * from groups LEFT JOIN group_user ON (groups.id = gid) LEFT JOIN users ON (users.id = uid) WHERE gid = '$id'";
		return $query;
	}
	*/

	function get_searchquery($string, $count = false) {
		$term = sprintf("ILIKE '%%%s%%'", pg_escape_string($string));
		$cond = "WHERE groupname $term";
		if($count)
			$query = "SELECT count(*) FROM groups $cond";
		else {
			$query = "SELECT * FROM groups $cond";
			$query = $query . " ORDER BY groupname";
		}

		return $query;
	}

	function insertquery($data) {
		$query = "BEGIN;";
		$query = sprintf("INSERT INTO groups (groupname) VALUES ('%s');",
				pg_escape_string($data['groupname']));
		pg_query($query);

		$query = sprintf("SELECT id FROM groups WHERE groupname = '%s';",
				pg_escape_string($data['groupname']));
		$result = pg_query($query);
		$gid = pg_fetch_result($result, 'id');

		$query = "";
		foreach($data['members'] as $mid) {
			$query .= sprintf("INSERT INTO group_user (gid, uid) VALUES ('%s', '%s');",
					$gid, (int)$mid);
		}
		$query .= "COMMIT;";
		pg_query($query);
	}

	function get_updatequery($data) {
		$query = "BEGIN;";
		$query .= sprintf("UPDATE groups SET groupname = '%s' WHERE id = '%s';",
				pg_escape_string($data['groupname']),
				$data['id']);
		$query .= sprintf("DELETE FROM group_user WHERE gid = '%s';",
				$data['id']);
		foreach($data['members'] as $mid) {
			$query .= sprintf("INSERT INTO group_user (gid, uid) VALUES ('%s', '%s');",
					$data['id'], (int)$mid);
		}
		$query .= "COMMIT;";
		return $query;
	}
}

?>
