<?php
require("config.php");

function GS_escape($string) {
	global $gs_charset;

	$string = htmlspecialchars($string);
	$string = mb_convert_encoding($string, $gs_charset, "UTF-8");
	return $string;
	#$orig = array("ä", "ö", "ü", "Ä", "Ö", "Ü", "ß", "€", "&", "<", ">");
	#$replace = array("ae", "oe", "ue", "Ae", "Oe", "Ue", "ss", "EUR", "&amp;", "&lt;", "&gt;");
	#return str_replace($orig, $replace, $string);
}

function get_GSPhonebook() {
	global $dsn, $gs_charset;

	$conn = pg_pconnect($dsn);
	$query = sprintf("SELECT * FROM phonebook WHERE gid IN
				(SELECT gid FROM group_user WHERE uid IN
					(SELECT id from users WHERE gshostname = '%s'))",
					pg_escape_string($_SERVER['REMOTE_ADDR']));
	$result = pg_query($query);
	$result = pg_fetch_all($result);
	$output = "<?xml version=\"1.0\" encoding=\"$gs_charset\"?>\n<AddressBook>\n";
	if($result)
		foreach($result as $row) {
			$output .= "<Contact>";
			$output .= "<LastName>" . GS_escape($row['lastname']) . "</LastName>";
			$output .= "<FirstName>" . GS_escape($row['firstname']);
			if($row['info']) {
				if($row['firstname'])
					$output .= " - ";
				$output .= GS_escape($row['info']);
			}
			$output .= "</FirstName>";
			$output .= "<Phone>";
			$output .= "<phonenumber>" . GS_escape($row['phonenumber']) . "</phonenumber>";
			$output .= "<accountindex>" . $row['accountindex'] . "</accountindex>";
			$output .= "</Phone>";
			$output .= "</Contact>\n";
		}
	else {
		$output .= "<Contact>";
		$output .= "<LastName>" . _("Empty: ") . $_SERVER['REMOTE_ADDR'] . "</LastName>";
		$output .= "<FirstName></FirstName>";
		$output .= "<Phone><phonenumber>0</phonenumber><accountindex></accountindex></Phone>";
		$output .= "</Contact>\n";
	}
	$output .= "</AddressBook>\n";
	/*
	$filename = tempnam("/tmp", "gs_phonebook.xml");
	$fd = fopen($filename, 'w');
	fwrite($fd, $output);
	fclose($fd);
	*/

	return $output;
};


$path = substr($_SERVER['REQUEST_URI'], strlen($_SERVER['SCRIPT_NAME']));
/* Strip away leading / */
while($path[0] == '/')
	$path = substr($path, 1);

/* Someone playing tricks with paths? */
if($path[0] == '.') {
	echo "Please be nice and just use a regular path.";
	exit;
}

$identify = array("bt200a.bin" => "BudgetTone 200",
			"bt200b.bin" => "BudgetTone 200",
			"bt200.bin" => "BudgetTone 200",
			"bt200c.bin" => "BudgetTone 200",
			"bt200d.bin" => "BudgetTone 200",
			"gxp1200d.bin" => "GXP-1200",
			"gxp2000a.bin" => "GXP-2000",
			"gxp2000b.bin" => "GXP-2000",
			"gxp2000.bin" => "GXP-2000",
			"gxp2000c.bin" => "GXP-2000",
			"gxp2000d.bin" => "GXP-2000",
			"gxp2010d.bin" => "GXP-2010",
			"gxp2020d.bin" => "GXP-2020",
			"gxv3000a.bin" => "GXV-3000");

$file = basename($path);

/* Identification */
if(substr($file, 0, 4) == 'boot') {
	$conn = pg_pconnect($dsn);
	pg_query("UPDATE users SET phone = 'Grandstream' WHERE gshostname = '" . pg_escape_string($_SERVER['REMOTE_ADDR']) . "'");
	syslog(LOG_DEBUG, "gsget.php: Phone startup at " . $_SERVER['REMOTE_ADDR']);
} elseif(isset($identify[$file])) {
	$conn = pg_pconnect($dsn);
	pg_query("UPDATE users SET phone = '" . $identify[$file] . "' WHERE gshostname = '" . pg_escape_string($_SERVER['REMOTE_ADDR']) . "'");
	syslog(LOG_DEBUG, "gsget.php: " . $identify[$file] . " identified at " . $_SERVER['REMOTE_ADDR']);
}

/* Downloads */
if($file == 'gs_phonebook.xml') {
	syslog(LOG_DEBUG, "gsget.php: Generating phonebook for " . $_SERVER['REMOTE_ADDR']);
	print get_GSPhonebook();
	exit;
} elseif(($file == 'ring1.bin') || ($file == 'ring2.bin') || ($file == 'ring3.bin')) {
	$conn = pg_pconnect($dsn);
	$query = sprintf("SELECT value FROM config WHERE key = '%s' AND uid = (SELECT id FROM users WHERE gshostname = '%s')",
			$file, pg_escape_string($_SERVER['REMOTE_ADDR']));
	$result = pg_query($query);
	if(pg_num_rows($result)) {
		$ringtone = pg_fetch_result($result, 'value');
		if(is_readable("$ringtonedir/$ringtone.ring")) {
			syslog(LOG_DEBUG, "gsget.php: Serving '$ringtone.ring' as $file to " . $_SERVER['REMOTE_ADDR']);
			readfile("$ringtonedir/$ringtone.ring");
			exit;
		} else
			syslog(LOG_DEBUG, "gsget.php: Ring tone '$ringtone.ring' not found for " . $_SERVER['REMOTE_ADDR']);
	}
}

$passname = $firmwaredir . "/" . $path;
if(is_readable($passname)) {
	syslog(LOG_DEBUG, "gsget.php: Serving $passname to " . $_SERVER['REMOTE_ADDR']);
	readfile($passname);
} else {
	syslog(LOG_DEBUG, "gsget.php: $passname not found for " . $_SERVER['REMOTE_ADDR']);
	header("HTTP/1.0 404 Not Found");
	echo "Sorry. No readable file found by that name.";
}
?>
