<?php
ini_set("session.gc_maxlifetime", 21600);
ini_set("session.name", "GSPBSESSID");
session_start();

header("Content-type: text/html; charset=UTF-8");

require("config.php");
$conn = pg_pconnect($dsn);

/* Localization */
$result = pg_query("SELECT value FROM config WHERE uid IS NULL AND key = 'LC_ALL'");
$locale = pg_fetch_result($result, 'value');
putenv("LC_ALL=$locale");
setlocale(LC_ALL, $locale);
bindtextdomain("messages", "./locale");
bind_textdomain_codeset("messages", "utf-8");
textdomain("messages");

/* Login/Logout */
if(isset($_REQUEST['logout'])) {
	$error = _("Logout successful.");
	unset($_SESSION['username']);
}

if(!isset($_SESSION['username'])) {
	if(isset($_REQUEST['username'])) {
		$result = pg_query(sprintf("SELECT * FROM users WHERE username = '%s' AND password = '%s'",
					pg_escape_string($_REQUEST['username']),
					pg_escape_string($_REQUEST['password'])));
		if(pg_num_rows($result) == 1) {
			$row = pg_fetch_array($result);
			$_SESSION['uid'] = $row['id'];
			$_SESSION['username'] = $row['username'];
			$_SESSION['admin'] = ($row['admin'] == 't') ? true:false;
			$_SESSION['phone'] = $row['phone'];
			$_SESSION['gshostname'] = $row['gshostname'];
			$_SESSION['ext'] = $row['ext'];
		} else
			$error = _("Wrong username or password!");
	}
}

if(!isset($_SESSION['username'])) {
	include('login.php');
	exit;
}

function get_logininfo() {
	$html = sprintf("%s (SIP/%s): %s @ %s",
			$_SESSION['username'],
			$_SESSION['ext'],
			$_SESSION['phone'],
			$_SESSION['gshostname']);
	return $html;
}

/* Let's begin */
	
require_once ("$xajaxdir/xajax_core/xajax.inc.php");

$xajax = new xajax("index.server.php");
//$xajax->setFlag('debug', true);
$xajax->registerFunction("history");

$xajax->registerFunction("select_move");

require("phonebook.php");
$xajax->registerFunction("pb_search");
$xajax->registerFunction("pb_editEntry");
$xajax->registerFunction("pb_saveEntry");
$xajax->registerFunction("pb_deleteEntry");

require("userpref.php");
$xajax->registerFunction("up_display");
$xajax->registerFunction("up_save");

if($_SESSION['admin']) {
	$xajax->registerFunction("admin");

	require("userlist.php");
	$xajax->registerFunction("ulist_search");
	$xajax->registerFunction("ulist_editEntry");
	$xajax->registerFunction("ulist_saveEntry");
	$xajax->registerFunction("ulist_deleteEntry");
	
	require("grouplist.php");
	$xajax->registerFunction("glist_search");
	$xajax->registerFunction("glist_editEntry");
	$xajax->registerFunction("glist_saveEntry");
	$xajax->registerFunction("glist_deleteEntry");

	require("globalpref.php");
	$xajax->registerFunction("gp_display");
	$xajax->registerFunction("gp_save");
}

function pb_search($string) {
	$pb = new phonebook();
	$objResponse = $pb->search($string);
	$objResponse->assign("submenu", "style.display", "none");
	return $objResponse;
}

function pb_editEntry($id) {
	$pb = new phonebook();
	return $pb->editEntry($id);
}

function pb_saveEntry($id) {
	$pb = new phonebook();
	return $pb->saveEntry($id);
}

function pb_deleteEntry($id, $string) {
	$pb = new phonebook();
	return $pb->deleteEntry($id, $string);
}


function ulist_search($string) {
	$ulist = new userlist();
	return $ulist->search($string);
}

function ulist_editEntry($id) {
	$ulist = new userlist();
	return $ulist->editEntry($id);
}

function ulist_saveEntry($id) {
	$ulist = new userlist();
	return $ulist->saveEntry($id);
}

function ulist_deleteEntry($id, $string) {
	$ulist = new userlist();
	return $ulist->deleteEntry($id, $string);
}


function glist_search($string) {
	$glist = new grouplist();
	return $glist->search($string);
}

function glist_editEntry($id) {
	$glist = new grouplist();
	return $glist->editEntry($id);
}

function glist_saveEntry($id) {
	$glist = new grouplist();
	return $glist->saveEntry($id);
}

function glist_deleteEntry($id, $string) {
	$glist = new grouplist();
	return $glist->deleteEntry($id, $string);
}

function up_display() {
	$up = new userpref();
	$objResponse = $up->display();
	$objResponse->assign("submenu", "style.display", "none");
	return $objResponse;
}

function up_save($data) {
	$up = new userpref();
	return $up->save($data);
}

function gp_display() {
	$gp = new globalpref();
	return $gp->display();
}

function gp_save($data) {
	$gp = new globalpref();
	return $gp->save($data);
}
?>
