<?php
require_once("prefobj.php");

class userpref extends prefobj {
	var $prefix = "up";
	var $focus = "username";

	function userpref() {
		$this->uid = $_SESSION['uid'];
	}

	function get_ringtoneList() {
		global $ringtonedir;

		$rtlist = array();
		foreach(glob("$ringtonedir/*.ring") as $filename) {
			$rtlist[] = basename($filename, '.ring');
		}
		return $rtlist;
	}

	function get_ringtoneSelect($nr, $default) {
		global $ringtonedir;

		$html = "<div class='editlabel'>" . _("Ring tone") . " $nr:</div>";
		$html .= "<select class='editpref' name='ring$nr.bin' id='ring$nr.bin'>\n";
		if($this->rtlist)
			foreach($this->rtlist as $ringtone)
				$html .= sprintf("<option%s>$ringtone</option>", ($default == $ringtone) ? ' selected':'');
		$html .= "</select>";
		$html .= " <a href='#' onclick='location.href=\"$ringtonedir/\" + document.getElementById(\"ring$nr.bin\").value + \".wav\"; return false'>";
		$html .= _("Test it") . "</a><br/>\n";

		return $html;
	}

	function html_editEntry($config) {
		$html = "<h2>" . _("User preferences") . "</h2>\n";
		$html .= "<div class='status' id='status'></div>\n";
		$html .= "<form id='pref' name='pref' action='#' onsubmit='xajax_" . $this->prefix . "_save(xajax.getFormValues(\"pref\"));return false'>\n";
		$html .= "<input type='hidden' name='id' value='$this->uid'>\n";
		$html .= "<h3>" . _("General preferences") . "</h3>\n";

		$result = pg_query("SELECT id,groupname FROM groups WHERE id IN (SELECT gid FROM group_user WHERE uid = '" . $_SESSION['uid'] . "')");
		$result = pg_fetch_all($result);
		$html .= "<div class='editlabel'>" . _("Default group") . " $nr:</div>";
		$html .= "<select class='editpref' name='defaultgid' id='defaultgid'>\n";
		if($result)
			foreach($result as $row)
				$html .= sprintf("<option value='%s'%s>%s</option>",
						$row['id'],
						($config['defaultgid'] == $row['id']) ? ' selected':'',
						$row['groupname']);
		$html .= "</select><span class='prefexpl'>" . _("Preselected group for newly created phonbook entries.") . "</span><br/>\n";
		/*
		$html .= "<div class='editlabel'>" . _("Language") . ":</div>";
		$html .= "<select class='editpref' name='LC_ALL'>\n";
		$languages = array("en_US.UTF-8" => _("English"),
					"de_DE.UTF-8" => _("German"));
		foreach($languages as $locale => $language)
			$html .= sprintf("<option value='%s'%s>%s</option>",
					$locale, ($config['LC_ALL'] == $locale) ? " selected":"", $language);
		$html .= "</select><br/>\n";
		*/
		$html .= "<h3>" . _("GS Phone preferences") . "</h3>\n";
		$html .= "<div class='prefexpl'>" . _("These options might require a reboot of your phone.") . "</div><br/>\n";

		$this->rtlist = $this->get_ringtoneList();
		$html .= $this->get_ringtoneSelect(1, $config['ring1.bin']);
		$html .= $this->get_ringtoneSelect(2, $config['ring2.bin']);
		$html .= $this->get_ringtoneSelect(3, $config['ring3.bin']);
		$html .= "<div class='prefexpl'>" . _("You still have to select in your phone which of the three ring tones should be used.") . "</div><br/>\n";

		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "</form>\n";

		return $html;
	}
}

?>
