<?php

class AMI {
	var $socket = false;
	var $error  = "";
 
	function login() {
		$ami_host     = get_config_value(0, "ami_host");
		$ami_port     = get_config_value(0, "ami_port");
		$ami_timeout  = get_config_value(0, "ami_timeout");

		$this->socket = @fsockopen($ami_host, $ami_port, $errno, $errstr, $ami_timeout); 
		if(!$this->socket) {
			$this->error = sprintf(_("Could not connect to Asterisk Manager Interface: %s (%s)"), $errstr, $errno);
			return false;
		} else {
			stream_set_timeout($this->socket, $ami_timeout); 

			$ami_login    = get_config_value(0, "ami_login");
			$ami_password = get_config_value(0, "ami_password");
	
			$ret = $this->query("Action: Login\r\nUserName: $ami_login\r\nSecret: $ami_password\r\nEvents: off\r\n\r\n"); 

			if(strpos($ret, "Message: Authentication accepted") !== false) {
				$this->context = get_config_value(0, "ami_context");
				return true;
			} else {
		 		$this->error = _("Asterisk Manager Interface - Authentication failed.");
				fclose($this->socket); 
				$this->socket = false;
		 		return false;
			}
		}
	}
	
	function logout() {
		if($this->socket) {
			fputs($this->socket, "Action: Logoff\r\n\r\n"); 
			while(!feof($this->socket)) { 
				$ret .= fread($this->socket, 8192); 
			} 
			fclose($this->socket); 
			$this->socket = false;
		}
	 	return; 
	}
	
	function query($query) {
		if($this->socket === false)
			return false;
			
		fputs($this->socket, $query); 
		$buf = "";
		do {
			$line = fgets($this->socket, 4096);
			$buf .= $line;
			$info = stream_get_meta_data($this->socket);
		} while ($line != "\r\n" && !$info['timed_out'] );

		return $buf;
	}

	function dial($src, $callerid, $dest) {
		$query  = "Action: Originate\r\n";
		$query .= "Channel: $src\r\n";
		$query .= "Context: $this->context\r\n";
		$query .= "Exten: $dest\r\n";
		$query .= "Priority: 1\r\n";
		$query .= "Callerid: $callerid\r\n";
		$query .= "Timeout: 10000\r\n";
		$query .= "\r\n";

		$ret = $this->query($query);
		if(strpos($ret, "Response: Error") !== false) {
			$this->error = sprintf(_("Asterisk Manager Interface: Dial failed:\n%s"), $ret);
			return false;
		}

		return true;
	}
} 
?>
