<?php
require("init.php");

require("callinfo.common.php");

function callinfo_clear() {
	$objResponse = new xajaxResponse();
	$objResponse->assign("callinfo", "style.display", "none");
	return $objResponse;
}

function callinfo_check() {

	$objResponse = new xajaxResponse();
	$last_update = $_SESSION['last_update'];
	$result = pg_query("SELECT value FROM state WHERE key = 'last_update' AND value::timestamp > '$last_update'");
	if(pg_num_rows($result)) {
		$_SESSION['last_update'] = pg_fetch_result($result, 'value');
		$callinfo = html_callinfo();
		if($callinfo) {
			$objResponse->assign("callinfo", "innerHTML", html_callinfo());
			$objResponse->assign("callinfo", "style.display", "block");
			$objResponse->script('clearTimeout(clear_callinfo_t); clear_callinfo_t = setTimeout("xajax_callinfo_clear()", 30000)');
		}
		#$objResponse->alert("last_update: " . $_SESSION['last_update']);
	}

	/* Handle next update */
	$callinfo_refresh = get_config_value(Null, 'callinfo_refresh');
	if($callinfo_refresh == '')
		$callinfo_refresh = 2;
	$callinfo_refresh = (float)$callinfo_refresh;
	$js = sprintf("last_update = '%s';", urlencode($_SESSION['last_update']));
	if($callinfo_refresh)
		$js .= sprintf("callinfo_refresh = %s; setTimeout('update_check()', %s);",
				$callinfo_refresh * 1000, $callinfo_refresh);
	$objResponse->script($js);
	return $objResponse;
}

function html_callinfo() {
	$query = sprintf("SELECT stime::timestamp(0), calleridname, callerid, state FROM history
				WHERE dest LIKE '%s-%%' AND
				(stime > '%s'::timestamp - '30 seconds'::interval
				 OR ptime > '%s'::timestamp - '30 seconds'::interval
				 OR etime > '%s'::timestamp - '30 seconds'::interval)
				 ORDER BY stime",
				 $_SESSION['ext'],
				 $_SESSION['last_update'], $_SESSION['last_update'], $_SESSION['last_update']);
	$result = pg_query($query);
	$result = pg_fetch_all($result);
	if($result) {
		$html = "<table>";
		foreach($result as $row) {
			$html .= "<tr>";
			$html .= $row['stime'] . ":";
			//$html .= strftime("<td>%X:</td>", $row['stime']);
			$html .= sprintf("<td>" . _('Call from "%s" &lt;%s&gt;.') . "</td>",
					$row['calleridname'], $row['callerid']);
			switch($row['state']) {
				case 0:
					$html .= "<td><b>" . _("Ringing") . "</b></td>";
					break;
				case 1:
					$html .= "<td><b>" . _("Talking") . "</b></td>";
					break;
				case 2:
					$html .= "<td><b>" . _("Hangup") . "</b></td>";
					break;
			}
			$html .= "</tr>\n";
		}
		$html .= "</table>";
	} else
		$html = "";

	return $html;
}

$xajax->processRequest();
?>
