<?php
require_once("prefobj.php");

class globalpref extends prefobj {
	var $prefix = "gp";
	var $focus = "username";

	function html_editEntry($config) {
		$html = "<h2>" . _("Global preferences") . "</h2>\n";
		$html .= "<div class='status' id='status'></div>\n";
		$html .= "<form id='pref' name='pref' action='#' onsubmit='xajax_" . $this->prefix . "_save(xajax.getFormValues(\"pref\"));return false'>\n";

		$html .= "<h3>" . _("General preferences") . "</h3>\n";
		$html .= "<div class='editlabel'>" . _("Language") . ":</div>";
		$html .= "<select class='editpref' name='LC_ALL'>\n";
		$languages = array("en_US.UTF-8" => _("English"),
					"de_DE.UTF-8" => _("German"));
		foreach($languages as $locale => $language)
			$html .= sprintf("<option value='%s'%s>%s</option>",
					$locale, ($config['LC_ALL'] == $locale) ? " selected":"", $language);
		$html .= "</select><br/>\n";
		$html .= "<div class='editlabel'>" . _("Callinfo refresh") . ":</div>";
		$html .= "<input type='text' class='editpref' name='callinfo_refresh' value='" . $config['callinfo_refresh'] . "' size=5/>\n";
		$html .= "<span class='prefexpl'>" . _("How often to check for callinfo updates (secs), e.g. '2'. '0' for no updates.") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("History length") . ":</div>";
		$html .= "<input type='text' class='editpref' name='history_length' value='" . $config['history_length'] . "' size=5/>\n";
		$html .= "<span class='prefexpl'>" . _("How much call history to keep (hours), e.g. '48'. '0' for no limit.") . "</span><br/>\n";

		$html .= "<h3>" . _("Asterisk Manager Interface preferences") . "</h3>\n";
		$html .= "<div class='editlabel'>" . _("AMI Hostname") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_host' value='" . $config['ami_host'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Hostname where to connect to the Asterisk Manager Interface (AMI), e.g. 'localhost'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Port") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_port' value='" . $config['ami_port'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Portnumber for the AMI. Probably '5038'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Dialout context") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_context' value='" . $config['ami_context'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Context for outgoing calls, e.g. 'default'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Timeout") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_timeout' value='" . $config['ami_timeout'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Timeout (secs) for the connection to the AMI, e.g. '2'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Login") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_login' value='" . $config['ami_login'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Login for the AMI. User needs 'call' permission.") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Password") . ":</div>";
		$html .= "<input type='password' class='editpref' name='ami_password' value='" . $config['ami_password'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Password for the AMI") . "</span><br/>\n";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "</form>\n";

		return $html;
	}
}

?>
