<?php
require_once("listobj.php");

class history extends listobj {
	var $tablename = "history";

	function html_listheader() {
		$html  = "<tr class='header'><th>" . _("Called ext.");
		$html .= "</th><th>" . _("Calling ext.");
		$html .= "</th><th>" . _("CallerID");
		$html .= "</th><th>" . _("Start time");
		$html .= "</th><th>" . _("Pickup time");
		$html .= "</th><th>" . _("Hangup time");
		$html .= "</th><th>" . _("State");
		$html .= "</th></tr>\n";
		
		return $html;
	}

	function get_extension($channel) {
		return substr($channel, 0, strrpos($channel, "-"));
	}

	function html_row($row) {
		$html  = sprintf("<td>%s</td></td>%s</td><td>%s &lt;%s&gt;",
				 $this->get_extension($row['dest']),
				 $this->get_extension($row['src']),
				 $row['calleridname'], $row['callerid']);
		if($_SESSION['ext'])
			$html .= sprintf(" <a href='#' onclick='xajax_dial(\"%s\")'><img class='dial' src='images/dial.png' title='" . _("Dial") . "'></a>",
					 $row['callerid']);
		$html .= sprintf("</td><td>%s</td>", $row['stime']);
		$html .= sprintf("<td>%s</td>", $row['ptime']);
		$html .= sprintf("<td>%s</td>", $row['etime']);
		switch($row['state']) {
			case 0:
				$state = _("Ringing");
				break;
			case 1:
				$state = _("Talking");
				break;
			case 2:
				if(!$row['etime'])
					$state = _("Unknown");
				else
					$state = $row['ptime'] ? $row['duration'] : _("Not answered");
				break;
			default:
				$state = _("Unknown");
		}
		$html .= sprintf("<td>%s</td>", $state);

		return $html;
	}

	function get_searchquery($string, $count = false) {
		$term = sprintf("ILIKE '%%%s%%'", pg_escape_string($string));
		$cond = "WHERE (src $term OR dest $term OR callerid $term OR calleridname $term)";
		if(!$_SESSION['admin'])
			$cond .= sprintf(" AND dest ILIKE '%s%%'", $_SESSION['ext']);
		if($count)
			$query = "SELECT count(*) FROM history $cond";
		else {
			$query = "SELECT dest, src, calleridname, callerid,
					stime::timestamp(0), ptime::timestamp(0),
					etime::timestamp(0), state,
					(etime - ptime)::interval(0) AS duration
					FROM history $cond ORDER BY stime DESC";
		}
		return $query;
	}
}

?>
