<?php
require_once("listobj.php");

class phonebook extends listobj {
	var $prefix = "pb";
	var $tablename = "phonebook";
	var $focus = "lastname";

	function get_permissionCond($idname) {
		if($_SESSION['admin'])
			return "true";

		return "$idname IN (SELECT gid FROM group_user WHERE uid = '" . $_SESSION['uid'] . "')";
	}

	function html_listheader() {
		$html  = "<tr class='header'><th>" . _("Lastname");
		$html .= "</th><th>" . _("Firstname");
		$html .= "</th><th>" . _("Info");
		$html .= "</th><th>" . _("Phonenumber");
		$html .= "</th><th>" . _("Group");
		$html .= "</th><th></th></tr>\n";
		$html .= "<tr id='row0'><td colspan='5'><a onclick='xajax_" . $this->prefix . "_editEntry(0);return false' href='#'>" . _("New entry") . "</a></td></tr>\n";
		
		return $html;
	}

	function html_editEntry($entry) {
		$id = (int)$entry['id'];
		$html  = "<td colspan='6'><form id='editform$id' name='editform' action='#' onsubmit='xajax_" . $this->prefix . "_saveEntry(xajax.getFormValues(\"editform$id\")); return false'>\n";
		$html .= "<input type='hidden' name='id' value='$id'/>";
		$html .= "<div class='editlabel'>" . _("Lastname") . ":</div>";
		$html .= "<input class='editlastname' type='text' id='lastname' name='lastname' value='" . $entry['lastname'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Firstname") . ":</div>";
		$html .= "<input class='editfirstname' type='text' name='firstname' value='" . $entry['firstname'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Info") . ":</div>";
		$html .= "<input class='editlastname' type='text' name='info' value='" . $entry['info'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Phonenumber") . ":</div>";
		$html .= "<input class='editlastname' type='text' name='phonenumber' value='" . $entry['phonenumber'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Group") . ":</div>";
		$html .= "<select name='gid' class='editgroup'>";
		$defaultgid = get_config_value($_SESSION['uid'], 'defaultgid');
		$result = pg_query("SELECT id, groupname FROM groups WHERE " . $this->get_permissionCond("id"));
		$result = pg_fetch_all($result);
		if($result)
			foreach($result as $row)
				$html .= sprintf("<option value='%s'%s>%s</option>",
						$row['id'],
						(($row['id'] == $entry['gid']) || (!$id && ($defaultgid == $row['id']))) ? ' selected':'',
						$row['groupname']);
		$html .= "</select><br/>\n";
		$html .= "<div class='editbuttons'>";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "<input type='button' value='" . _("Back") . "' onclick='xajax_" . $this->prefix . "_search(document.getElementById(\"searchbox\").value)'/>\n";
		$html .= "<input type='button' value='" . _("Delete entry") . "' onclick='xajax_" . $this->prefix . "_deleteEntry($id,document.getElementById(\"searchbox\").value)'/>";
		$html .= "</div></form></td>";

		return $html;
	}

	function html_row($row) {
		if(!isset($row['groupname'])) { 	/* Newly saved entry has no groupname info */
			$gid = (int)$row['gid'];
			$result = pg_query("SELECT groupname FROM groups WHERE id = '$gid'");
			$row['groupname'] = pg_fetch_result($result, 'groupname');
		}
		$html  = sprintf("<td>%s</td><td>%s</td><td>%s</td>",
				 $row['lastname'], $row['firstname'], $row['info']);
		$html .= sprintf("<td class='phonenumber'>%s", $row['phonenumber']);
		if($_SESSION['ext'])
			$html .= sprintf(" <a href='#' onclick='xajax_dial(\"%s\")'><img class='dial' src='images/dial.png' title='" . _("Dial") . "'></a>",
					 $row['phonenumber']);
		$html .= sprintf("</td><td>%s</td>", $row['groupname']);
		$html .= "<td><a href='#' onclick='xajax_" . $this->prefix . "_editEntry(" . $row['id'] . "); return false;'>";
		$html .= "<img class='edit' src='images/edit.png' title='" . _("Edit") . "'></a></td>";

		return $html;
	}

	function get_searchquery($string, $count = false) {
		$term = sprintf("ILIKE '%%%s%%'", pg_escape_string($string));
		$cond = "WHERE (firstname $term OR lastname $term OR info $term OR phonenumber $term) AND " . $this->get_permissionCond("gid");
		if($count)
			$query = "SELECT count(*) FROM phonebook $cond";
		else {
			$query = "SELECT phonebook.*, groups.id AS gid, groups.groupname FROM phonebook LEFT JOIN groups ON (phonebook.gid = groups.id) $cond";
			$query = $query . " ORDER BY lastname, firstname, info, phonenumber";
		}
		return $query;
	}

	function insertquery($data) {
		$query = sprintf("INSERT INTO phonebook (lastname, firstname, info, phonenumber, accountindex, gid) VALUES ('%s', '%s', '%s', '%s', 0, '%s')",
				pg_escape_string($data['lastname']),
				pg_escape_string($data['firstname']),
				pg_escape_string($data['info']),
				pg_escape_string($data['phonenumber']),
				(int)$data['gid']);
		pg_query($query);
	}

	function get_updatequery($data) {
		$query = sprintf("UPDATE phonebook SET lastname = '%s', firstname = '%s', info = '%s', phonenumber = '%s', accountindex = 0,
					gid = '%s' WHERE id = '%s' AND " . $this->get_permissionCond("gid"),
				pg_escape_string($data['lastname']),
				pg_escape_string($data['firstname']),
				pg_escape_string($data['info']),
				pg_escape_string($data['phonenumber']),
				(int)$data['gid'],
				$data['id']);
		return $query;
	}
}

?>
