<?php
require_once("listobj.php");

class userlist extends listobj {
	var $prefix = "ulist";
	var $tablename = "users";
	var $focus = "username";

	function html_listheader() {
		$html  = "<tr class='header'><th>" . _("Username");
		$html .= "</th><th>" . _("Admin");
		$html .= "</th><th>" . _("Extension");
		$html .= "</th><th>" . _("CallerID");
		$html .= "</th><th>" . _("GS hostname");
		$html .= "</th><th>" . _("Phonetype");
		$html .= "</th><th></th></tr>\n";
		$html .= "<tr id='row0'><td colspan='5'><a onclick='xajax_" . $this->prefix . "_editEntry(0);return false' href='#'>" . _("New entry") . "</a></td></tr>\n";
		
		return $html;
	}

	function html_editEntry($entry) {
		$id = (int)$entry['id'];
		$html  = "<td colspan='6'><form id='editform$id' name='editform' action='#' onsubmit='xajax_" . $this->prefix . "_saveEntry(xajax.getFormValues(\"editform$id\")); return false'>\n";
		$html .= "<input type='hidden' name='id' value='$id'/>";
		$html .= "<div class='editlabel'>" . _("Username") . ":</div>";
		$html .= "<input class='editusername' type='text' id='username' name='username' value='" . $entry['username'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Password") . ":</div>";
		$html .= "<input class='editpassword' type='password' id='password' name='password' value='" . $entry['password'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Administrator") . ":</div>";
		$html .= "<input class='editadmin' type='checkbox' id='admin' name='admin' value='t' " . (($entry['admin'] == 't')?'checked':'') . "/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Extension") . ":</div>";
		$html .= "<input class='editext' type='text' name='ext' value='" . $entry['ext'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Phone extension of user, e.g. 'SIP/user'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("CallerID") . ":</div>";
		$html .= "<input class='editcallerid' type='text' name='callerid' value='" . $entry['callerid'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Phonetype") . ":</div>";
		$html .= $entry['phone'] . "<br/>\n";
		$html .= "<div class='editlabel'>" . _("GS hostname") . ":</div>";
		$html .= "<input class='editsipext' type='text' name='gshostname' value='" . $entry['gshostname'] . "'/><br/>\n";
		/*
		$html .= "<div class='editlabel'>" . _("GS password") . ":</div>";
		$html .= "<input class='editsipext' type='password' name='gspassword' value='" . $entry['gspassword'] . "'/><br/>\n";
		*/
		$html .= "<div class='editbuttons'>";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "<input type='button' value='" . _("Back") . "' onclick='xajax_" . $this->prefix . "_search(document.getElementById(\"searchbox\").value)'/>\n";
		$html .= "<input type='button' value='" . _("Delete entry") . "' onclick='xajax_" . $this->prefix . "_deleteEntry($id,document.getElementById(\"searchbox\").value)'/>";
		$html .= "</div></form></td>";

		return $html;
	}

	function html_row($row) {
		$html = sprintf("<td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td>",
				 $row['username'], ($row['admin'] == 't') ? "X":"", $row['ext'], $row['callerid'], gethostbyname($row['gshostname']), $row['phone']);
		$html .= "<td><a href='#' onclick='xajax_" . $this->prefix . "_editEntry(" . $row['id'] . "); return false;'>E</a></td>";

		return $html;
	}

	function get_searchquery($string, $count = false) {
		$term = sprintf("ILIKE '%%%s%%'", pg_escape_string($string));
		$cond = "WHERE username $term OR ext $term OR gshostname $term OR callerid $term";
		if($count)
			$query = "SELECT count(*) FROM users $cond";
		else {
			$query = "SELECT * FROM users $cond";
			$query = $query . " ORDER BY username, ext";
		}

		return $query;
	}

	function insertquery($data) {
		$query = "BEGIN;";
		$query .= sprintf("UPDATE users SET gshostname = '' WHERE gshostname = '%s';",
					gethostbyname($data['gshostname']));
		$query .= sprintf("INSERT INTO users (username, ext, callerid, gshostname, password, admin) VALUES ('%s', '%s', '%s', '%s', '%s', '%s');",
				pg_escape_string($data['username']),
				pg_escape_string($data['ext']),
				pg_escape_string($data['callerid']),
				gethostbyname($data['gshostname']),
				pg_escape_string($data['password']),
				($data['admin'] == 't')? 't':'f');
		$query .= sprintf("INSERT INTO groups (groupname) VALUES ('%s');", pg_escape_string($data['username']));
		pg_query($query);

		$result = pg_query(sprintf("SELECT id FROM groups WHERE groupname = '%s'", pg_escape_string($data['username'])));
		$gid = pg_fetch_result($result, 'id');
		$result = pg_query(sprintf("SELECT id FROM users WHERE username = '%s'", pg_escape_string($data['username'])));
		$uid = pg_fetch_result($result, 'id');

		pg_query("INSERT INTO group_user (gid, uid) VALUES ('$gid', '$uid'); COMMIT");
	}

	function get_updatequery($data) {
		$query = "BEGIN;";
		$query .= sprintf("UPDATE users SET gshostname = '' WHERE gshostname = '%s' AND username != '%s';",
					gethostbyname($data['gshostname']),
					pg_escape_string($data['username']));
		$query .= sprintf("UPDATE users SET username = '%s', ext = '%s', callerid = '%s', gshostname = '%s', password = '%s', admin = '%s' WHERE id = '%s';",
				pg_escape_string($data['username']),
				pg_escape_string($data['ext']),
				pg_escape_string($data['callerid']),
				gethostbyname($data['gshostname']),
				pg_escape_string($data['password']),
				($data['admin'] == 't')? 't':'f',
				$data['id']);
		$query .= "COMMIT;";
		return $query;
	}

	function get_deletequery($id) {
		$result = pg_query("SELECT username FROM users WHERE id = '$id'");
		$username = pg_fetch_result($result, 'username');

		$query = "BEGIN;";
		$query .= "DELETE FROM " . $this->tablename . " WHERE id = '$id';";
		$query .= "DELETE FROM groups WHERE groupname = '$username';";
		$query .= "COMMIT";

		return $query;
	}
}

?>
