<?php
require_once("prefobj.php");

class userblfpref extends prefobj {
	var $prefix = "up_blf";
	var $focus = "username";

	function userblfpref() {
		$this->uid = $_SESSION['uid'];
	}

	function get_htmlBLF($config, $nr) {
		$html  = "<h3>" . sprintf(_("BLF %d"), $nr + 1) . "</h3>\n";
		$html .= "<div class='editlabel'>" . _("Display name") . ":</div>";
		$html .= "<input type='text' name='blf_name_$nr' value='" . htmlspecialchars($config["blf_name_$nr"]) . "'><br/>";
		$html .= "<div class='editlabel'>" . _("Extension(s)") . ":</div>";
		$html .= "<input type='text' name='blf_ext_$nr' value='" . htmlspecialchars($config["blf_ext_$nr"]) . "' size=60><br/>\n";
		return $html;
	}

	function html_editEntry($config) {
		$html .= "<h2>" . _("Busy-Lamp-Field (BLF) configuration") . "</h2>";
		$html .= "<div class='status' id='status'></div>\n";
		$html .= "<div class='prefexpl'>" . _("Here you can configure your BLFs. You can monitor several extension with one BLF just seperate the extensions with an '&'-sign under 'Extension(s)', e.g. 'SIP/phone1&SIP/phone2'.") . "</div>\n";
		$html .= "<div class='prefexpl'>" . _("To attach to hints defined in Asterisk use 'hint/name', but this will give you no information on channels in use at this extension.") . "</div>\n";
		$html .= "<div class='prefexpl'>" . _("You can also monitor external SIP-Servers. Just put the name of the server (as known to Asterisk) in the 'Extension(s)' field, e.g. 'sip.qsc.de'. The BLF will then show you if Asterisk is registered to the server or if the server is unreachable.") . "</div><br/>\n";
		$html .= "<form id='pref' name='pref' action='#' onsubmit='xajax_" . $this->prefix . "_save(xajax.getFormValues(\"pref\"));return false'>\n";
		$html .= "<input type='hidden' name='id' value='$this->uid'>\n";
		$html .= "<span id='blf_conf'>";
		$i = 0;
		while(True) {
			if(!isset($config["blf_ext_$i"]))
				break;
			$html .= $this->get_htmlBLF($config, $i);
			$i++;
		}
		$html .= $this->get_htmlBLF($config, $i);
		$html .= "</span>\n";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "</form>\n";

		return $html;
	}

	function save($data) {
		$data['id'] = (int)$data['id'];


		if($data['id'] != $this->uid) {
			$objResponse = new xajaxResponse();
			$objResponse->assign("status", "innerHTML", _("Error saving preferences. Wrong UserID."));
			return $objResponse;
		}

		$i = -1;
		$j = 0;
		$query = "BEGIN;";
		$query .= $this->get_deletequery();
		while(True) {
			$i++;
			if(!isset($data["blf_ext_$i"]))
				break;
			if(!$data["blf_ext_$i"])
				continue;
			if(!$data["blf_name_$i"])
				$data["blf_name_$i"] = $data["blf_ext_$i"];
			$query .= $this->get_savequery("blf_ext_$j", $data["blf_ext_$i"]);
			$query .= $this->get_savequery("blf_name_$j", $data["blf_name_$i"]);
			$j++;
		}
		$query .= "COMMIT;";
		pg_query($query);

		$objResponse = $this->display();
		$objResponse->assign("status", "innerHTML", _("BLF information saved."));
		update_blf();
		$objResponse->assign("blflist", "innerHTML", html_blf());
		$objResponse->script("xajax_callinfo_check()");
			
		return $objResponse;
	}


	function get_deletequery() {
		$query = "DELETE FROM config WHERE uid = '$this->uid' AND key LIKE 'blf_%';";
		return $query;
	}


	function get_selectquery() {
		$query = "SELECT * FROM config WHERE uid = '$this->uid' AND key LIKE 'blf_%'";
		return $query;
	}

}

?>
