--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: config; Type: TABLE; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE TABLE config (
    uid integer,
    "key" text NOT NULL,
    value text
);


ALTER TABLE public.config OWNER TO gsphonebook;

--
-- Name: group_user; Type: TABLE; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE TABLE group_user (
    gid integer,
    uid integer
);


ALTER TABLE public.group_user OWNER TO gsphonebook;

--
-- Name: groups; Type: TABLE; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE TABLE groups (
    id serial NOT NULL,
    groupname text
);


ALTER TABLE public.groups OWNER TO gsphonebook;

--
-- Name: history; Type: TABLE; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE TABLE history (
    src text NOT NULL,
    dest text NOT NULL,
    stime timestamp without time zone NOT NULL,
    ptime timestamp without time zone,
    etime timestamp without time zone,
    src_callerid text,
    src_calleridname text,
    state smallint,
    dest_callerid text,
    dest_calleridname text,
    cause smallint
);


ALTER TABLE public.history OWNER TO gsphonebook;

--
-- Name: phonebook; Type: TABLE; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE TABLE phonebook (
    id serial NOT NULL,
    lastname text,
    firstname text,
    info text,
    phonenumber text,
    accountindex smallint,
    gid integer,
    extrafields text
);


ALTER TABLE public.phonebook OWNER TO gsphonebook;

--
-- Name: state; Type: TABLE; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE TABLE state (
    "key" text NOT NULL,
    value text
);


ALTER TABLE public.state OWNER TO gsphonebook;

--
-- Name: states; Type: TABLE; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE TABLE states (
    ext text NOT NULL,
    state smallint,
    channel text,
    peerchannel text,
    callerid text,
    calleridname text,
    ts timestamp without time zone
);


ALTER TABLE public.states OWNER TO gsphonebook;

--
-- Name: users; Type: TABLE; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE TABLE users (
    id serial NOT NULL,
    username text,
    ext text,
    gshostname text,
    "password" text,
    "admin" boolean,
    phone text,
    callerid text
);


ALTER TABLE public.users OWNER TO gsphonebook;

--
-- Name: groups_pkey; Type: CONSTRAINT; Schema: public; Owner: gsphonebook; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_pkey PRIMARY KEY (id);


--
-- Name: phonebook_pkey; Type: CONSTRAINT; Schema: public; Owner: gsphonebook; Tablespace: 
--

ALTER TABLE ONLY phonebook
    ADD CONSTRAINT phonebook_pkey PRIMARY KEY (id);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: gsphonebook; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: states_ext; Type: INDEX; Schema: public; Owner: gsphonebook; Tablespace: 
--

CREATE INDEX states_ext ON states USING btree (ext);


--
-- Name: config_uid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: gsphonebook
--

ALTER TABLE ONLY config
    ADD CONSTRAINT config_uid_fkey FOREIGN KEY (uid) REFERENCES users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: group_user_gid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: gsphonebook
--

ALTER TABLE ONLY group_user
    ADD CONSTRAINT group_user_gid_fkey FOREIGN KEY (gid) REFERENCES groups(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: group_user_uid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: gsphonebook
--

ALTER TABLE ONLY group_user
    ADD CONSTRAINT group_user_uid_fkey FOREIGN KEY (uid) REFERENCES users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: phonebook_gid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: gsphonebook
--

ALTER TABLE ONLY phonebook
    ADD CONSTRAINT phonebook_gid_fkey FOREIGN KEY (gid) REFERENCES groups(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: config; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE config FROM PUBLIC;
REVOKE ALL ON TABLE config FROM gsphonebook;
GRANT ALL ON TABLE config TO gsphonebook;


--
-- Name: group_user; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE group_user FROM PUBLIC;
REVOKE ALL ON TABLE group_user FROM gsphonebook;
GRANT ALL ON TABLE group_user TO gsphonebook;


--
-- Name: groups; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE groups FROM PUBLIC;
REVOKE ALL ON TABLE groups FROM gsphonebook;
GRANT ALL ON TABLE groups TO gsphonebook;


--
-- Name: groups_id_seq; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE groups_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE groups_id_seq FROM gsphonebook;
GRANT ALL ON TABLE groups_id_seq TO gsphonebook;


--
-- Name: history; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE history FROM PUBLIC;
REVOKE ALL ON TABLE history FROM gsphonebook;
GRANT ALL ON TABLE history TO gsphonebook;


--
-- Name: phonebook; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE phonebook FROM PUBLIC;
REVOKE ALL ON TABLE phonebook FROM gsphonebook;
GRANT ALL ON TABLE phonebook TO gsphonebook;


--
-- Name: phonebook_id_seq; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE phonebook_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE phonebook_id_seq FROM gsphonebook;
GRANT ALL ON TABLE phonebook_id_seq TO gsphonebook;


--
-- Name: state; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE state FROM PUBLIC;
REVOKE ALL ON TABLE state FROM gsphonebook;
GRANT ALL ON TABLE state TO gsphonebook;


--
-- Name: states; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE states FROM PUBLIC;
REVOKE ALL ON TABLE states FROM gsphonebook;
GRANT ALL ON TABLE states TO gsphonebook;


--
-- Name: users; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE users FROM PUBLIC;
REVOKE ALL ON TABLE users FROM gsphonebook;
GRANT ALL ON TABLE users TO gsphonebook;


--
-- Name: users_id_seq; Type: ACL; Schema: public; Owner: gsphonebook
--

REVOKE ALL ON TABLE users_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE users_id_seq FROM gsphonebook;
GRANT ALL ON TABLE users_id_seq TO gsphonebook;


--
-- PostgreSQL database dump complete
--

INSERT INTO users (username, password, admin) VALUES ('admin', 'admin', 't');
INSERT INTO groups (groupname) VALUES ('admin');
INSERT INTO group_user (gid, uid) VALUES (1, 1);
