<?php
require_once("prefobj.php");

define('ACCOUNTINDEX_MAX', 6);

class globalpref extends prefobj {
	var $prefix = "gp";
	var $focus = "username";

	function html_editEntry($config) {
		$html = "<h2>" . _("Global preferences") . "</h2>\n";
		$html .= "<div class='status' id='status'></div>\n";
		$html .= "<form id='pref' name='pref' action='#' onsubmit='xajax_" . $this->prefix . "_save(xajax.getFormValues(\"pref\"));return false'>\n";

		$html .= "<h3>" . _("General preferences") . "</h3>\n";
		$html .= "<div class='editlabel'>" . _("Language") . ":</div>";
		$html .= "<select class='editpref' name='LC_ALL'>\n";
		$languages = array("en_US.UTF-8" => _("English"),
					"de_DE.UTF-8" => _("German"));
		foreach($languages as $locale => $language)
			$html .= sprintf("<option value='%s'%s>%s</option>",
					$locale, ($config['LC_ALL'] == $locale) ? " selected":"", $language);
		$html .= "</select><br/>\n";

		$html .= "<div class='editlabel'>" . _("Callinfo refresh") . ":</div>";
		$html .= "<input type='text' class='editpref' name='callinfo_refresh' value='" . $config['callinfo_refresh'] . "' size=5/>\n";
		$html .= "<span class='prefexpl'>" . _("How often to check for callinfo updates (secs), e.g. '2'. '0' for no updates.") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("History length") . ":</div>";
		$html .= "<input type='text' class='editpref' name='history_length' value='" . $config['history_length'] . "' size=5/>\n";
		$html .= "<span class='prefexpl'>" . _("How much call history to keep (hours), e.g. '48'. '0' for no limit.") . "</span><br/>\n";

		$html .= "<div class='editlabel'>" . _("Ringing prefix for BLFs") . ":</div>";
		$html .= "<input type='text' name='blf_ringing_prefix' value='" . htmlspecialchars($config["blf_ringing_prefix"]) . "' size=5>\n";
		$html .= "<span class='prefexpl'>" . _("This gets prepended to the phonenumber when you click on a BLF that indicates ringing. This should probably be '**' if you want to allow pickups.") . "</span><br/>\n";

		$html .= "<div class='editlabel'>" . _("Show ringing channels") . ":</div>";
		$html .= sprintf("<input type='checkbox' name='blf_show_ringing' %s>\n",
					$config["blf_show_ringing"] ? "checked":"");
		$html .= "<span class='prefexpl'>" . _("Show ringing channel information in BLFs.") . "</span><br clear='left'/>\n";

		$html .= "<div class='editlabel'>" . _("Show connected channels") . ":</div>";
		$html .= sprintf("<input type='checkbox' name='blf_show_connected' %s>\n",
					$config["blf_show_connected"] ? "checked":"");
		$html .= "<span class='prefexpl'>" . _("Show connected channel information in BLFs.") . "</span><br clear='left'/>\n";

		$html .= "<div class='editlabel'>" . _("Allow pickup of ringing channels") . ":</div>";
		$html .= sprintf("<input type='checkbox' name='blf_allow_pickup' %s>\n",
					$config["blf_allow_pickup"] ? "checked":"");
		$html .= "<span class='prefexpl'>" . _("Allow ringing channels to be picked up.") . "</span><br clear='left'/>\n";

		$html .= "<div class='editlabel'>" . _("Allow steal of channels") . ":</div>";
		$html .= sprintf("<input type='checkbox' name='blf_allow_steal' %s>\n",
					$config["blf_allow_steal"] ? "checked":"");
		$html .= "<span class='prefexpl'>" . _("Allow connected channels to be \"stolen\" up.") . "</span><br clear='left'/>\n";

		$html .= "<div class='editlabel'>" . _("Extra fields") . ":</div>";
		$html .= "<input type='text' class='editpref' name='extrafields' value='" . $config['extrafields'] . "' size=60/>\n";
		$html .= "<span class='prefexpl'>" . _("Seperate with '&'") . "</span><br clear='left'/>\n";


		$html .= "<h3>" . _("Phonebook preferences") . "</h3>\n";
		$html .= "<div class='editlabel'>" . _("Selectable accounts") . ":</div>";
		$html .= "<select class='editpref' name='accountindex_max'>\n";
		for($i = 1; $i <= ACCOUNTINDEX_MAX; $i++) {
			$html .= sprintf("<option value='%d'%s>" . ngettext("%d account", "%d accounts", $i) . "</option>\n",
						$i, ($i == $config['accountindex_max']) ? " selected":"", $i);
		}
		$html .= "</select>\n";
		$html .= "<span class='prefexpl'>" . _("How many accounts to offer for phonebook entries.") . "</span><br/>\n";

		$html .= "<div class='editlabel'>" . _("Fix accountindex") . ":</div>";
		$html .= "<select class='editpref' name='accountindex_fix'>\n";
		$accountindex_max = $config['accountindex_max'];
		if(!$accountindex_max)
			$accountindex_max = 6;
		$html .= sprintf("<option value='0'%s>" . _("No fix accountindex") . "</option>\n",
					(!$config['accountindex_fix']) ? " selected":"");
		for($i = 1; $i <= $accountindex_max; $i++) {
			$html .= sprintf("<option value='%d'%s>" . _("Account %d") . "</option>\n",
						$i, ($i == $config['accountindex_fix']) ? " selected":"", $i);
		}
		$html .= "</select>\n";
		$html .= "<span class='prefexpl'>" . _("Use a fix accountindex for all phonebook entries or let the user decide?") . "</span><br/>\n";


		$html .= "<h3>" . _("Asterisk Manager Interface preferences") . "</h3>\n";
		$html .= "<div class='editlabel'>" . _("AMI Hostname") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_host' value='" . $config['ami_host'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Hostname where to connect to the Asterisk Manager Interface (AMI), e.g. 'localhost'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Port") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_port' value='" . $config['ami_port'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Portnumber for the AMI. Probably '5038'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Dialout context") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_context' value='" . $config['ami_context'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Context for outgoing calls, e.g. 'default'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Timeout") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_timeout' value='" . $config['ami_timeout'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Timeout (secs) for the connection to the AMI, e.g. '2'") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Login") . ":</div>";
		$html .= "<input type='text' class='editpref' name='ami_login' value='" . $config['ami_login'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Login for the AMI. User needs 'call' permission.") . "</span><br/>\n";
		$html .= "<div class='editlabel'>" . _("AMI Password") . ":</div>";
		$html .= "<input type='password' class='editpref' name='ami_password' value='" . $config['ami_password'] . "'/>\n";
		$html .= "<span class='prefexpl'>" . _("Password for the AMI") . "</span><br/>\n";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "</form>\n";

		return $html;
	}
}

?>
