<?php

/*
 * The following arrays contain useful data:
 * $user: id, username, ext, gshostname, admin, phone, callerid
 * $calls: Entries with ext, callerid, calleridname
 *
 * $path contains the relativ path to idledir the eventual subdirectory
 * (if called via gsget.php/subdirectory/gs_screen.xml)
 */
print "<?xml version=\"1.0\"?>\n";

if(!$calls) {		// No incoming calls
	$filename = sprintf("$path/gs_screen.idle.%s.xml", $user['phone']);
	if(!is_readable($filename))
		$filename = "$path/gs_screen.idle.xml";
	readfile($filename);
	exit;
}

// Incoming calls.

$ystart = 0;
if($user['phone'] == 'GXP-2000') {
	$yinc = 28;
	$callinfo = 'shorter';
	$softkeys = False;
} else {
	$yinc = 41;
	$callinfo = 'longer';
	$softkeys = True;
}


?>
<Screen>
  <IdleScreen>
      <ShowStatusLine>true</ShowStatusLine>
      <DisplayString font="f13h" halign="Left">
          <DisplayStr>$I</DisplayStr>
          <X>6</X>
          <Y>128</Y>
      </DisplayString>
<?php
$y = $ystart;
foreach($calls as $call) {
	if($callinfo == 'shorter') {
		printf('<DisplayString font="f16b" halign="Left"> <DisplayStr>%s: %s</DisplayStr> <X>0</X> <Y>%i</Y> </DisplayString>', $call['ext'], $y);
		printf('<DisplayString font="f16b" halign="Left"> <DisplayStr>%s</DisplayStr> <X>20</X> <Y>%i</Y> </DisplayString>', $call['callerid'], $y + 13);
	} else {
		printf('<DisplayString font="f16b" halign="Left"> <DisplayStr>%s:</DisplayStr> <X>0</X> <Y>%s</Y> </DisplayString>', $call['ext'], $y);
		printf('<DisplayString font="f16b" halign="Left"> <DisplayStr>%s</DisplayStr> <X>6</X> <Y>%s</Y></DisplayString>', $call['callerid'], $y + 13);
		printf('<DisplayString font="f16b" halign="Left"> <DisplayStr>%s</DisplayStr> <X>6</X> <Y>%s</Y> </DisplayString>', $call['calleridname'], $y + 26);
	}
	$y += $yinc;
}

if($softkeys) {
?>
      <SoftKeys>
          <SoftKey>
              <Label>Missed Calls</Label>
              <Action>
                  <MissedCalls/>
              </Action>
              <displayCondition>
                <conditionType>missCall</conditionType>
              </displayCondition>
          </SoftKey>

	   <SoftKey>
              <Label>CancelFwd</Label>
              <Action>
                  <CancelFwd/>
              </Action>
              <displayCondition>
                <conditionType>callFwded</conditionType>
              </displayCondition>
          </SoftKey>
          
          <SoftKey>
              <Label>ForwardAll</Label>
              <Action>
                  <FwdAll/>
              </Action>
          </SoftKey>
          
          <SoftKey>
              <Label>Call Return</Label>
              <Action>
                  <CallReturn/>
              </Action>
          </SoftKey>      

      </SoftKeys>
<?php
}
?>
  </IdleScreen>
</Screen>
