<?php
require("index.common.php");

function select_move($options, $srcid, $destid) {
	$objResponse = new xajaxResponse();
	foreach($options as $option) {
		$value = $option[0];
		$text = $option[1];
		$objResponse->create($destid, "option", "$destid$value");
		$objResponse->assign("$destid$value", "value", $value);
		$objResponse->assign("$destid$value", "innerHTML", $text);
		$objResponse->remove("$srcid$value");
	}
	//print_r(array($options, $srcid, $destid));
	return $objResponse;
}

function history($string)
{
	$objResponse = new xajaxResponse();
	$objResponse->assign("content", "innerHTML", "History");
	$objResponse->assign("submenu", "style.display", "none");
	return $objResponse;
}

/* Phonebook */
require_once("phonebook.php");
function pb_search($string) {
	$pb = new phonebook();
	$objResponse = $pb->search($string);
	$objResponse->assign("submenu", "style.display", "none");
	return $objResponse;
}

function pb_editEntry($id) {
	$pb = new phonebook();
	return $pb->editEntry($id);
}

function pb_saveEntry($id) {
	$pb = new phonebook();
	return $pb->saveEntry($id);
}

function pb_deleteEntry($id, $string) {
	$pb = new phonebook();
	return $pb->deleteEntry($id, $string);
}

/* History */
require("history.php");
function history_search($string) {
	$history = new history();
	$objResponse = $history->search($string);
	$objResponse->assign("submenu", "style.display", "none");
	return $objResponse;
}

/* Administration */
if($_SESSION['admin']) {
	require("userlist.php");
	
	require("grouplist.php");

	require("globalpref.php");

	function html_adminSubMenu()
	{
		$html = "<li><a href='#' onclick='setSearchType(\"off\");xajax_gp_display(\"\");return false;'>" . _("Preferences") . "</a></li>";
		$html .= "<li><a href='#' onclick='setSearchType(\"admin_user\");xajax_ulist_search(\"\");return false;'>" . _("Users") . "</a></li>";
		$html .= "<li><a href='#' onclick='setSearchType(\"admin_group\");xajax_glist_search(\"\");return false;'>" . _("Groups") . "</a></li>";
		return $html;
	}

	function admin()
	{
		//$objResponse = new xajaxResponse();
		//$objResponse->assign("content", "innerHTML", "");
		$objResponse = gp_display();
		$objResponse->assign("submenu", "innerHTML", html_adminSubMenu());
		$objResponse->assign("submenu", "style.display", "block");
		return $objResponse;
	}

	function ulist_search($string) {
		$ulist = new userlist();
		return $ulist->search($string);
	}

	function ulist_editEntry($id) {
		$ulist = new userlist();
		return $ulist->editEntry($id);
	}

	function ulist_saveEntry($id) {
		$ulist = new userlist();
		return $ulist->saveEntry($id);
	}

	function ulist_deleteEntry($id, $string) {
		$ulist = new userlist();
		return $ulist->deleteEntry($id, $string);
	}


	function glist_search($string) {
		$glist = new grouplist();
		return $glist->search($string);
	}

	function glist_editEntry($id) {
		$glist = new grouplist();
		return $glist->editEntry($id);
	}

	function glist_saveEntry($id) {
		$glist = new grouplist();
		return $glist->saveEntry($id);
	}

	function glist_deleteEntry($id, $string) {
		$glist = new grouplist();
		return $glist->deleteEntry($id, $string);
	}

	function gp_display() {
		$gp = new globalpref();
		return $gp->display();
	}

	function gp_save($data) {
		$gp = new globalpref();
		return $gp->save($data);
	}
}


/* User preferences */
require("userpref.php");
function html_userprefSubMenu()
{
	$html = "<li><a href='#' onclick='xajax_up_display(\"\");return false;'>" . _("Preferences") . "</a></li>";
	$html .= "<li><a href='#' onclick='xajax_up_blf_display(\"\");return false;'>" . _("Busy-Lamp-Field") . "</a></li>";
	$html .= "<li><a href='#' onclick='xajax_up_callinfo_display(\"\");return false;'>" . _("Callinfo") . "</a></li>";
	$html .= "<li><a href='#' onclick='xajax_up_pw_display(\"\");return false;'>" . _("Change password") . "</a></li>";
	return $html;
}

function up_display() {
	$up = new userpref();
	$objResponse = $up->display();
	$objResponse->assign("submenu", "innerHTML", html_userprefSubMenu());
	$objResponse->assign("submenu", "style.display", "block");
	return $objResponse;
}

function up_save($data) {
	$up = new userpref();
	return $up->save($data);
}

require("userblfpref.php");
function up_blf_display() {
	$ubp = new userblfpref();
	$objResponse = $ubp->display();
	return $objResponse;
}

function up_blf_save($data) {
	$ubp = new userblfpref();
	return $ubp->save($data);
}

require("usercallinfopref.php");
function up_callinfo_display() {
	$ucp = new usercallinfopref();
	$objResponse = $ucp->display();
	return $objResponse;
}

function up_callinfo_save($data) {
	$ucp = new usercallinfopref();
	return $ucp->save($data);
}

require("userpwpref.php");
function up_pw_display() {
	$upp = new userpwpref();
	$objResponse = $upp->display();
	return $objResponse;
}

function up_pw_save($data) {
	$upp = new userpwpref();
	return $upp->save($data);
}

/* Dialing */
function do_dial($src, $callerid, $dest)
{
	# Simplistic check if someone tries to inject AMI commands
	if(strpos($src . $callerid . $dest, "\n") !== False)
		return;

	require("ami.php");
	$ami = new AMI();

	if(!$ami->login())
		return $ami->error;

	if(!$ami->dial($src, $callerid, $dest)) {
		return $ami->error;
	}
	$ami->logout();
	return;
}

function dial($dest)
{
	$ret = do_dial($_SESSION['ext'], $_SESSION['callerid'], $dest);

	$objResponse = new xajaxResponse();
	if($ret)
		$objResponse->alert($ret);

	return $objResponse;
}

function redirect($channel) {
	# Simplistic check if someone tries to inject AMI commands
	if(strpos($channel, "\n") !== False)
		return;

	require("ami.php");
	$ami = new AMI();

	$objResponse = new xajaxResponse();
	if(!$ami->login()) {
		$objResponse->alert($ami->error);
		return $objResponse;
	}
	if(!$ami->redirect(trim($channel), $_SESSION['callerid'])) {
		$objResponse->alert($ami->error);
		return $objResponse;
	}

	return $objResponse;
}

$xajax->processRequest();
?>
