<?php
require_once("listobj.php");

class phonebook extends listobj {
	var $prefix = "pb";
	var $tablename = "phonebook";
	var $focus = "lastname";
	var $accountindex_fix = "";
	var $extrafields = array();

	function phonebook() {
		$this->accountindex_fix = get_config_value(Null, 'accountindex_fix');
		$this->extrafields = explode("&", get_config_value(Null, 'extrafields'));
	}

	function get_permissionCond($idname) {
		if($_SESSION['admin'])
			return "true";

		return "$idname IN (SELECT gid FROM group_user WHERE uid = '" . $_SESSION['uid'] . "')";
	}

	function html_listheader() {
		$html  = "<tr class='header'><th>" . _("Lastname");
		$html .= "</th><th>" . _("Firstname");
		$html .= "</th><th>" . _("Info");
		$html .= "</th><th>" . _("Phonenumber");
		if(!$this->accountindex_fix)
			$html .= "</th><th>" . _("Account");
		foreach($this->extrafields as $field) {
			$html .= "</th><th>$field";
		}
		$html .= "</th><th>" . _("Group");
		$html .= "</th><th></th></tr>\n";
		$html .= "<tr id='row0'><td colspan='5'><a onclick='xajax_" . $this->prefix . "_editEntry(0);return false' href='#'>" . _("New entry") . "</a></td></tr>\n";
		
		return $html;
	}

	function assign_html_editEntry($objResponse, $id, $entry) {
		$id = (int)$entry['id'];
		$span = 6 + sizeof($this->extrafields);
		$html  = "<form id='editform$id' name='editform' action='#' onsubmit='xajax_" . $this->prefix . "_saveEntry(xajax.getFormValues(\"editform$id\")); return false'>\n";
		$html .= "<input type='hidden' name='id' value='$id'/>";
		$html .= "<div class='editlabel'>" . _("Lastname") . ":</div>";
		$html .= "<input class='editlastname' type='text' id='lastname' name='lastname' value='" . $entry['lastname'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Firstname") . ":</div>";
		$html .= "<input class='editfirstname' type='text' name='firstname' value='" . $entry['firstname'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Info") . ":</div>";
		$html .= "<input class='editlastname' type='text' name='info' value='" . $entry['info'] . "'/><br/>\n";
		$html .= "<div class='editlabel'>" . _("Phonenumber") . ":</div>";
		$html .= "<input class='editlastname' type='text' name='phonenumber' value='" . $entry['phonenumber'] . "'/><br/>\n";
		if(!$this->accountindex_fix) {
			$accountindex = (int)$entry['accountindex'];
			if(!$accountindex)
				$accountindex = (int)get_config_value($_SESSION['uid'], 'general_defaultaccount');
			$html .= "<div class='editlabel'>" . _("Accountindex") . ":</div>";
			$html .= "<select name='accountindex' class='editgroup'>";
			$accountindex_max = get_config_value(Null, 'accountindex_max', 6);
			for($i = 0; $i < $accountindex_max; $i++) {
				$html .= sprintf("<option value='%d'%s>" . _("Account %d") . "</option>\n",
							$i, ($i == $accountindex) ? " selected":"", $i + 1);
			}
			$html .= "</select><br/>\n";
		}
		$extras = explode("&", $entry['extrafields']);
		for($i = 0; $i < sizeof($this->extrafields); $i++) {
			$key = $this->extrafields[$i];
			$val = urldecode($extras[$i]);
			$html .= "<div class='editlabel'>$key:</div>";
			$html .= "<input class='editextra' type='text' name='extra[]' value='$val'/><br/>\n";
		}
		$html .= "<div class='editlabel'>" . _("Group") . ":</div>";
		$html .= "<select name='gid' class='editgroup'>";
		$defaultgid = get_config_value($_SESSION['uid'], 'general_defaultgid');
		$result = pg_query("SELECT id, groupname FROM groups WHERE " . $this->get_permissionCond("id"));
		$result = pg_fetch_all($result);
		if($result)
			foreach($result as $row)
				$html .= sprintf("<option value='%s'%s>%s</option>",
						$row['id'],
						(($row['id'] == $entry['gid']) || (!$id && ($defaultgid == $row['id']))) ? ' selected':'',
						$row['groupname']);
		$html .= "</select><br/>\n";
		$html .= "<div class='editbuttons'>";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "<input type='button' value='" . _("Back") . "' onclick='xajax_" . $this->prefix . "_search(document.getElementById(\"searchbox\").value)'/>\n";
		$html .= "<input type='button' value='" . _("Delete entry") . "' onclick='xajax_" . $this->prefix . "_deleteEntry($id,document.getElementById(\"searchbox\").value)'/>";
		$html .= "</div></form>";

		$objResponse->create("row$id", "td", "td$id");
		$objResponse->assign("td$id", "colSpan", $span);
		$objResponse->assign("td$id", "innerHTML", $html);
	}

	function html_row($row) {
		if(!isset($row['groupname'])) { 	/* Newly saved entry has no groupname info */
			$gid = (int)$row['gid'];
			$result = pg_query("SELECT groupname FROM groups WHERE id = '$gid'");
			$row['groupname'] = pg_fetch_result($result, 'groupname');
		}
		$html  = sprintf("<td>%s</td><td>%s</td><td>%s</td>",
				 $row['lastname'], $row['firstname'], $row['info']);
		$html .= sprintf("<td class='phonenumber'>%s", $row['phonenumber']);
		if($_SESSION['ext'])
			$html .= sprintf(" <a href='#' onclick='xajax_dial(\"%s\")'><img class='dial' src='images/dial.png' title='" . _("Dial") . "'></a>",
					 $row['phonenumber']);
		$html .= "</td>";
		if(!$this->accountindex_fix)
			$html .= sprintf("<td>%s</td>", $row['accountindex'] + 1);

		if(!isset($row['extrafields']))		# Saved entry
			$extras = (array)$row['extra'];
		else
			$extras = explode("&", $row['extrafields']);
		for($i = 0; $i < sizeof($this->extrafields); $i++) {
			$html .= sprintf("<td>%s</td>", urldecode($extras[$i]));
		}

		$html .= sprintf("<td>%s</td>", $row['groupname']);
		$html .= "<td><a href='#' onclick='xajax_" . $this->prefix . "_editEntry(" . $row['id'] . "); return false;'>";
		$html .= "<img class='edit' src='images/edit.png' title='" . _("Edit") . "'></a></td>";

		return $html;
	}

	function get_searchquery($string, $count = false) {
		$term = sprintf("ILIKE '%%%s%%'", pg_escape_string($string));
		$extraterm = sprintf("ILIKE '%%%s%%'", pg_escape_string(urlencode($string)));
		$cond = "WHERE (firstname $term OR lastname $term OR info $term OR phonenumber $term OR extrafields $extraterm) AND " . $this->get_permissionCond("gid");
		if($count)
			$query = "SELECT count(*) FROM phonebook $cond";
		else {
			$query = "SELECT phonebook.*, groups.id AS gid, groups.groupname FROM phonebook LEFT JOIN groups ON (phonebook.gid = groups.id) $cond";
			$query = $query . " ORDER BY lastname, firstname, info, phonenumber";
		}
		return $query;
	}

	function insertquery($data) {
		$accountindex = $this->accountindex_fix;
		if(!$accountindex)
			$accountindex = (int)$data['accountindex'];
		else
			$accountindex--;	# accountindex_fix is 1-based

		for($i = 0; $i < sizeof($data['extra']); $i++)
			$data['extra'][$i] = urlencode($data['extra'][$i]);

		$query = sprintf("INSERT INTO phonebook (lastname, firstname, info, phonenumber, accountindex, extrafields, gid) VALUES ('%s', '%s', '%s', '%s', '%d', '%s', '%s')",
				pg_escape_string($data['lastname']),
				pg_escape_string($data['firstname']),
				pg_escape_string($data['info']),
				pg_escape_string($data['phonenumber']),
				$accountindex,
				pg_escape_string(implode("&", $data['extra'])),
				(int)$data['gid']);
		pg_query($query);
	}

	function get_updatequery($data) {
		$accountindex = $this->accountindex_fix;
		if(!$accountindex)
			$accountindex = (int)$data['accountindex'];
		else
			$accountindex--;	# accountindex_fix is 1-based

		for($i = 0; $i < sizeof($data['extra']); $i++)
			$data['extra'][$i] = urlencode($data['extra'][$i]);

		$query = sprintf("UPDATE phonebook SET lastname = '%s', firstname = '%s', info = '%s', phonenumber = '%s', accountindex = %s,
					extrafields = '%s', gid = '%s' WHERE id = '%s' AND " . $this->get_permissionCond("gid"),
				pg_escape_string($data['lastname']),
				pg_escape_string($data['firstname']),
				pg_escape_string($data['info']),
				pg_escape_string($data['phonenumber']),
				$accountindex,
				pg_escape_string(implode("&", $data['extra'])),
				(int)$data['gid'],
				$data['id']);
		return $query;
	}
}

?>
