<?php
class prefobj {
	/* Whose preferences to edit */
	var $uid = "";
	// Input element to focus on edit
	var $focus = "";

	/*
		Functions to override:
			html_editEntry($config)
	*/

	function display() {
		$objResponse = new xajaxResponse();
		$objResponse->assign("content", "innerHTML", $this->get_display());
		return $objResponse;
	}

	function save($data) {
		$data['id'] = (int)$data['id'];

		$objResponse = new xajaxResponse();

		if($data['id'] != $this->uid) {
			$objResponse->assign("status", "innerHTML", _("Error saving preferences. Wrong UserID."));
			return $objResponse;
		}

		$query = "BEGIN;";
		$query .= $this->get_deletequery();
		foreach($data as $key => $value) {
			if($key == 'id')
				continue;
			$query .= $this->get_savequery($key, $value);
		}
		$query .= "COMMIT;";
		pg_query($query);

		$objResponse->assign("status", "innerHTML", _("Preferences saved."));
			
		return $objResponse;
	}

	function get_savequery($key, $value) {
		if($this->uid)
			$query = sprintf("INSERT INTO config (uid, key, value) VALUES ('%s', '%s', '%s');",
					$this->uid,
					pg_escape_string($key),
					pg_escape_string($value));
		else
			$query = sprintf("INSERT INTO config (key, value) VALUES ('%s', '%s');",
					pg_escape_string($key),
					pg_escape_string($value));
		return $query;
	}

	function get_deletequery() {
		if($this->uid)
			$query = "DELETE FROM config WHERE uid = '$this->uid';";
		else
			$query = "DELETE FROM config WHERE uid IS NULL;";

		return $query;
	}


	function get_selectquery() {
		if($this->uid)
			$query = "SELECT * FROM config WHERE uid = '$this->uid'";
		else
			$query = "SELECT * FROM config WHERE uid IS NULL";

		return $query;
	}

	function get_display() {
		$query = $this->get_selectquery();
		$result = pg_query($query);
		$result = pg_fetch_all($result);

		$config = array('id' => $this->uid);
		if($result)
			foreach($result as $row)
				$config[$row['key']] = $row['value'];

		return $this->html_editEntry($config);
	}
}

?>
