<?php
/*
 * Asterisk causes for disconnection
 * (from asterisk-1.4.16.2/include/asterisk/causes.h)
 */

define("AST_CAUSE_UNALLOCATED", 1);
define("AST_CAUSE_NO_ROUTE_TRANSIT_NET", 2);
define("AST_CAUSE_NO_ROUTE_DESTINATION", 3);
define("AST_CAUSE_CHANNEL_UNACCEPTABLE", 6);
define("AST_CAUSE_CALL_AWARDED_DELIVERED", 7);
define("AST_CAUSE_NORMAL_CLEARING", 16);
define("AST_CAUSE_USER_BUSY", 17);
define("AST_CAUSE_NO_USER_RESPONSE", 18);
define("AST_CAUSE_NO_ANSWER", 19);
define("AST_CAUSE_CALL_REJECTED", 21);
define("AST_CAUSE_NUMBER_CHANGED", 22);
define("AST_CAUSE_DESTINATION_OUT_OF_ORDER", 27);
define("AST_CAUSE_INVALID_NUMBER_FORMAT", 28);
define("AST_CAUSE_FACILITY_REJECTED", 29);
define("AST_CAUSE_RESPONSE_TO_STATUS_ENQUIRY", 30);
define("AST_CAUSE_NORMAL_UNSPECIFIED", 31);
define("AST_CAUSE_NORMAL_CIRCUIT_CONGESTION", 34);
define("AST_CAUSE_NETWORK_OUT_OF_ORDER", 38);
define("AST_CAUSE_NORMAL_TEMPORARY_FAILURE", 41);
define("AST_CAUSE_SWITCH_CONGESTION", 42);
define("AST_CAUSE_ACCESS_INFO_DISCARDED", 43);
define("AST_CAUSE_REQUESTED_CHAN_UNAVAIL", 44);
define("AST_CAUSE_PRE_EMPTED", 45);
define("AST_CAUSE_FACILITY_NOT_SUBSCRIBED", 50);
define("AST_CAUSE_OUTGOING_CALL_BARRED", 52);
define("AST_CAUSE_INCOMING_CALL_BARRED", 54);
define("AST_CAUSE_BEARERCAPABILITY_NOTAUTH", 57);
define("AST_CAUSE_BEARERCAPABILITY_NOTAVAIL", 58);
define("AST_CAUSE_BEARERCAPABILITY_NOTIMPL", 65);
define("AST_CAUSE_CHAN_NOT_IMPLEMENTED", 66);
define("AST_CAUSE_FACILITY_NOT_IMPLEMENTED", 69);
define("AST_CAUSE_INVALID_CALL_REFERENCE", 81);
define("AST_CAUSE_INCOMPATIBLE_DESTINATION", 88);
define("AST_CAUSE_INVALID_MSG_UNSPECIFIED", 95);
define("AST_CAUSE_MANDATORY_IE_MISSING", 96);
define("AST_CAUSE_MESSAGE_TYPE_NONEXIST", 97);
define("AST_CAUSE_WRONG_MESSAGE", 98);
define("AST_CAUSE_IE_NONEXIST", 99);
define("AST_CAUSE_INVALID_IE_CONTENTS", 100);
define("AST_CAUSE_WRONG_CALL_STATE", 101);
define("AST_CAUSE_RECOVERY_ON_TIMER_EXPIRE", 102);
define("AST_CAUSE_MANDATORY_IE_LENGTH_ERROR", 103);
define("AST_CAUSE_PROTOCOL_ERROR", 111);
define("AST_CAUSE_INTERWORKING", 127);

/*
 * Cause translations
 * (from asterisk-1.4.16.2/main/channel.c)
 */

$ast_causes = array(
        AST_CAUSE_UNALLOCATED => _("Unallocated (unassigned) number"),
        AST_CAUSE_NO_ROUTE_TRANSIT_NET => _("No route to specified transmit network"),
        AST_CAUSE_NO_ROUTE_DESTINATION => _("No route to destination"),
        AST_CAUSE_CHANNEL_UNACCEPTABLE => _("Channel unacceptable"),
        AST_CAUSE_CALL_AWARDED_DELIVERED => _("Call awarded and being delivered in an established channel"),
        AST_CAUSE_NORMAL_CLEARING => _("Normal Clearing"),
        AST_CAUSE_USER_BUSY => _("User busy"),
        AST_CAUSE_NO_USER_RESPONSE => _("No user responding"),
        AST_CAUSE_NO_ANSWER => _("User alerting, no answer"),
        AST_CAUSE_CALL_REJECTED => _("Call Rejected"),
        AST_CAUSE_NUMBER_CHANGED => _("Number changed"),
        AST_CAUSE_DESTINATION_OUT_OF_ORDER => _("Destination out of order"),
        AST_CAUSE_INVALID_NUMBER_FORMAT => _("Invalid number format"),
        AST_CAUSE_FACILITY_REJECTED => _("Facility rejected"),
        AST_CAUSE_RESPONSE_TO_STATUS_ENQUIRY => _("Response to STATus ENQuiry"),
        AST_CAUSE_NORMAL_UNSPECIFIED => _("Normal, unspecified"),
        AST_CAUSE_NORMAL_CIRCUIT_CONGESTION => _("Circuit/channel congestion"),
        AST_CAUSE_NETWORK_OUT_OF_ORDER => _("Network out of order"),
        AST_CAUSE_NORMAL_TEMPORARY_FAILURE => _("Temporary failure"),
        AST_CAUSE_SWITCH_CONGESTION => _("Switching equipment congestion"),
        AST_CAUSE_ACCESS_INFO_DISCARDED => _("Access information discarded"),
        AST_CAUSE_REQUESTED_CHAN_UNAVAIL => _("Requested channel not available"),
        AST_CAUSE_PRE_EMPTED => _("Pre-empted"),
        AST_CAUSE_FACILITY_NOT_SUBSCRIBED => _("Facility not subscribed"),
        AST_CAUSE_OUTGOING_CALL_BARRED => _("Outgoing call barred"),
        AST_CAUSE_INCOMING_CALL_BARRED => _("Incoming call barred"),
        AST_CAUSE_BEARERCAPABILITY_NOTAUTH => _("Bearer capability not authorized"),
        AST_CAUSE_BEARERCAPABILITY_NOTAVAIL => _("Bearer capability not available"),
        AST_CAUSE_BEARERCAPABILITY_NOTIMPL => _("Bearer capability not implemented"),
        AST_CAUSE_CHAN_NOT_IMPLEMENTED => _("Channel not implemented"),
        AST_CAUSE_FACILITY_NOT_IMPLEMENTED => _("Facility not implemented"),
        AST_CAUSE_INVALID_CALL_REFERENCE => _("Invalid call reference value"),
        AST_CAUSE_INCOMPATIBLE_DESTINATION => _("Incompatible destination"),
        AST_CAUSE_INVALID_MSG_UNSPECIFIED => _("Invalid message unspecified"),
        AST_CAUSE_MANDATORY_IE_MISSING => _("Mandatory information element is missing"),
        AST_CAUSE_MESSAGE_TYPE_NONEXIST => _("Message type nonexist."),
        AST_CAUSE_WRONG_MESSAGE => _("Wrong message"),
        AST_CAUSE_IE_NONEXIST => _("Info. element nonexist or not implemented"),
        AST_CAUSE_INVALID_IE_CONTENTS => _("Invalid information element contents"),
        AST_CAUSE_WRONG_CALL_STATE => _("Message not compatible with call state"),
        AST_CAUSE_RECOVERY_ON_TIMER_EXPIRE => _("Recover on timer expiry"),
        AST_CAUSE_MANDATORY_IE_LENGTH_ERROR => _("Mandatory IE length error"),
        AST_CAUSE_PROTOCOL_ERROR => _("Protocol error, unspecified"),
        AST_CAUSE_INTERWORKING => _("Interworking, unspecified")
);

?>
