<?php
class listobj {
	// Underlying SQL-Table
	var $tablename = "";
	// Input element to focus on edit
	var $focus = "";

	/*
		Functions to override:
			html_editEntry($data)
			html_row($data)
			html_listheader()
			get_searchquery($string, $count)
			insertquery($data)
			get_updatequery($data)
	*/

	function search($string) {
		$objResponse = new xajaxResponse();
		$objResponse->assign("content", "innerHTML", $this->get_list($string));
		return $objResponse;
	}

	function editEntry($id) {
		$objResponse = new xajaxResponse();
		$objResponse->script("remove_children('row$id')");
		$this->assign_editEntry($objResponse, $id);
		$objResponse->script("document.getElementById('" . $this->focus . "').focus()");
		return $objResponse;
	}

	function deleteEntry($id, $string) {
		$objResponse = new xajaxResponse();
		$id = (int)$id;
		if(!$id)
			return;
	
		$query = $this->get_deletequery($id);
		pg_query($query);

		$objResponse->remove("row$id");

		$result = pg_query($this->get_searchquery($string, true));
		$num = pg_fetch_result($result, 'count');
		$objResponse->assign("numentries", "innerHTML", $this->get_numentries($num));

		return $objResponse;
	}

	function saveEntry($data) {
		$data['id'] = (int)$data['id'];
		if(!$data['id']) {
			$this->insertquery($data);
			return $this->search("");
		}

		$query = $this->get_updatequery($data);
		$result = pg_query($query);

		$objResponse = new xajaxResponse();
		$html = $this->html_row($data);
		$objResponse->assign("row" . $data['id'], "innerHTML", $html);
		return $objResponse;
	}


	function get_numentries($num) {
		return sprintf(ngettext("%d entry", "%d entries", $num), $num);
	}

	function html_listfooter($num) {
		$html = "<div id='numentries'>" . $this->get_numentries($num) . "</div>\n";

		return $html;
	}

	function get_list($string) {
		$query = $this->get_searchquery($string);
		$result = pg_query($query);
		$num = pg_num_rows($result);
		$result = pg_fetch_all($result);

		$html = "<table>";
		$html .= $this->html_listheader();
		if($result) {
			$i = 0;
			foreach($result as $row) {
				$html .= sprintf("<tr id='row%s' class='%s'>%s</tr>\n",
						$row['id'],
						($i % 2) ? 'odd':'even',
						$this->html_row($row));
				$i++;
			}
		}
		$html .= "</table>\n";
		$html .= $this->html_listfooter($num);

		return $html;
	}

	function get_selectquery($id) {
		$query = "SELECT * FROM " . $this->tablename . " WHERE id = '$id';";
		return $query;
	}

	function get_deletequery($id) {
		$query = "DELETE FROM " . $this->tablename . " WHERE id = '$id'";
		return $query;
	}

	function assign_editEntry($objResponse, $id) {
		$id = (int)$id;
		if($id) {
			$query = $this->get_selectquery($id);
			$result = pg_query($query);
			$entry = pg_fetch_array($result, 0);
		} else
			$entry = array();

		$this->assign_html_editEntry($objResponse, $id, $entry);
	}

}

?>
