var xmlhttp=false;			// xmlhttp object for fast callinfo check without xajax
var searchFunc = xajax_pb_search;	// Which search function to call when user types something in the searchbox
var clear_callinfo_t;			// timeout to clear callinfo display
var last_update = '1970-01-01';
var callinfo_refresh = 5000;

window.onload = function() {
	set_xmlhttp();
	setTimeout("update_check()", 5000);
}

/*
 * Find the right xmlhttp object for the used browser
 */
function set_xmlhttp() {
	/*@cc_on @*/
	/*@if (@_jscript_version >= 5)
	// JScript gives us Conditional compilation, we can cope with old IE versions.
	// and security blocked creation of the objects.
	try {
		xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
	} catch (e) {
		try {
			xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
		} catch (E) {
			xmlhttp = false;
		}
	}
	@end @*/
	if (!xmlhttp && typeof XMLHttpRequest!='undefined') {
		try {
			xmlhttp = new XMLHttpRequest();
		} catch (e) {
			xmlhttp=false;
		}
	}
	if (!xmlhttp && window.createRequest) {
		try {
			xmlhttp = window.createRequest();
		} catch (e) {
			xmlhttp=false;
		}
	}
}

/*
 * Do a real quick check (no xajax) if the state on the server is newer than our local state.
 * If so do a xajax update.
 * This should decrease the load on the client.
 */
function update_check() {
	xmlhttp.open("GET", "update_check.php?last_update=" + last_update, true);
	xmlhttp.onreadystatechange = function() {
		if (xmlhttp.readyState==4) {
			if(xmlhttp.responseText == '1')
				xajax_callinfo_check();
			else {
				setTimeout("update_check()", callinfo_refresh);
			}
		}
	}
	xmlhttp.send(null);
}

/*
 * Buffer keystrokes so we don't send a search request for every keyup event
 */
var OnKeyRequestBuffer = {
	bufferText: false,
	bufferTime: 250,
        
	modified : function(strId) {
		setTimeout('OnKeyRequestBuffer.compareBuffer("'+strId+'","'+xajax.$(strId).value+'");', this.bufferTime);
	},
        
	compareBuffer : function(strId, strText) {
		if (strText == xajax.$(strId).value && strText != this.bufferText) {
			this.bufferText = strText;
			OnKeyRequestBuffer.makeRequest(strId);
		}
        },
        
	makeRequest : function(strId) {
		searchFunc(xajax.$(strId).value);
        }
}

/*
 * Dial when user presses enter in quickdial box
 */
function dial_on_enter(t, e) {
	var keycode;
	if (window.event) keycode = window.event.keyCode;	/* IE */
	else if (e) keycode = e.which;				/* rest of the world */
	else return true;

	if (keycode == 13) {
		xajax_dial(xajax.$('dialbox').value);
   		return false;
	} else
	   	return true;
}

/*
 * Adjust searchFunc so the right kind of search is performed or disable
 * searchbox to disables searches
 * type: phonebook || history || admin_user || admin_group || off
 */
function setSearchType(type) {
	sb = document.getElementById('searchbox');
	sb.value = '';
	switch(type) {
		case 'history':
			sb.disabled = false;
			searchFunc = xajax_history_search;;
			break;
		case 'admin_user':
			sb.disabled = false;
			searchFunc = xajax_ulist_search;
			break;
		case 'admin_group':
			sb.disabled = false;
			searchFunc = xajax_glist_search;
			break;
		case 'off':
			sb.disabled = true;
			break;
		default:
			sb.disabled = false;
			searchFunc = xajax_pb_search;
	}
}

/*
 * Get all/selected options in a select box
 * type: all || selected
 */
function get_options(id, type) {
	options = document.getElementById(id).childNodes;
	list = new Array();
	for(i = 0; i < options.length; i++) {
		if((type == 'all') || (options[i].selected))
			list.push(new Array(options[i].value, options[i].innerHTML));
	}
	return list;
}

/*
 * Select every option in a select box, so it gets sent in the submit request
 */
function select_options(id) {
	options = document.getElementById(id).childNodes;
	for(i = 0; i < options.length; i++)
		options[i].selected = true;
}

/*
 * Remove all children of a node
 */
function remove_children(id) {
	children = document.getElementById(id).childNodes;
	for (i = children.length - 1; i >= 0; i--) {
		xajax.dom.remove(children.item(i));
	};
}
