<?php
require("config.php");

define("PB_ENTRY_MAX_LENGTH", 20);

function GS_escape($string) {
	global $gs_charset;

	$string = htmlspecialchars($string);
	$string = mb_convert_encoding($string, $gs_charset, "UTF-8");
	return $string;
	#$orig = array("ä", "ö", "ü", "Ä", "Ö", "Ü", "ß", "€", "&", "<", ">");
	#$replace = array("ae", "oe", "ue", "Ae", "Oe", "Ue", "ss", "EUR", "&amp;", "&lt;", "&gt;");
	#return str_replace($orig, $replace, $string);
}

function get_GSPhonebook() {
	global $dsn, $gs_charset, $debug;

	$conn = pg_pconnect($dsn);
	$query = sprintf("SELECT * FROM phonebook WHERE gid IN
				(SELECT gid FROM group_user WHERE uid IN
					(SELECT id from users WHERE gshostname = '%s'))",
					pg_escape_string($_SERVER['REMOTE_ADDR']));
	$result = pg_query($query);
#print $query;
	$result = pg_fetch_all($result);
#print_r($result);
	$output = "<?xml version=\"1.0\" encoding=\"$gs_charset\"?>\n<AddressBook>\n";
	if($result)
		foreach($result as $row) {
			$output .= "<Contact>";
			$ln_len = mb_strlen($row['lastname'], 'UTF-8');
			$fn_len = mb_strlen($row['firstname'], 'UTF-8');
			if($row['info'] && $row['firstname'])
				$row['info'] = " - " . $row['info'];
			if($ln_len >= PB_ENTRY_MAX_LENGTH) {
				$row['lastname'] = mb_substr($row['lastname'], 0, PB_ENTRY_MAX_LENGTH, 'UTF-8');
				$row['firstname'] = "";
				$row['info'] = "";
			} elseif($ln_len + $fn_len + 1 >= PB_ENTRY_MAX_LENGTH) {
				$row['firstname'] = mb_substr($row['firstname'], 0, PB_ENTRY_MAX_LENGTH - 1 - $ln_len, 'UTF-8');
				$row['info'] = "";
			} else {
				$row['info'] = mb_substr($row['info'], 0, PB_ENTRY_MAX_LENGTH - 1 - $ln_len - $fn_len, 'UTF-8');
			}
			$output .= "<LastName>" . GS_escape($row['lastname']) . "</LastName>";
			$output .= "<FirstName>" . GS_escape($row['firstname']);
			if($row['info'])
				$output .= GS_escape($row['info']);
			$output .= "</FirstName>";
			$output .= "<Phone>";
			$output .= "<phonenumber>" . GS_escape($row['phonenumber']) . "</phonenumber>";
			$output .= "<accountindex>" . $row['accountindex'] . "</accountindex>";
			$output .= "</Phone>";
			$output .= "</Contact>\n";
		}
	else {
		$output .= "<Contact>";
		$output .= "<LastName>" . _("Empty: ") . $_SERVER['REMOTE_ADDR'] . "</LastName>";
		$output .= "<FirstName></FirstName>";
		$output .= "<Phone><phonenumber>0</phonenumber><accountindex></accountindex></Phone>";
		$output .= "</Contact>\n";
	}
	$output .= "</AddressBook>\n";

	if($debug) {
		$filename = tempnam("/tmp", "gs_phonebook.xml");
		$fd = fopen($filename, 'w');
		fwrite($fd, $output);
		fclose($fd);
	}

	return $output;
};


$path = substr($_SERVER['REQUEST_URI'], strlen($_SERVER['SCRIPT_NAME']));
/* Strip away leading / */
while($path[0] == '/')
	$path = substr($path, 1);

/* Someone playing tricks with paths? */
if($path[0] == '.') {
	echo "Please be nice and just use a regular path.";
	exit;
}

$identify = array("bt200a.bin" => "BudgetTone 200",
			"bt200b.bin" => "BudgetTone 200",
			"bt200.bin" => "BudgetTone 200",
			"bt200c.bin" => "BudgetTone 200",
			"bt200d.bin" => "BudgetTone 200",
			"bt200e.bin" => "BudgetTone 200",
			"gxp1200d.bin" => "GXP-1200",
			"gxp1200e.bin" => "GXP-1200",
			"gxp2000a.bin" => "GXP-2000",
			"gxp2000b.bin" => "GXP-2000",
			"gxp2000.bin" => "GXP-2000",
			"gxp2000c.bin" => "GXP-2000",
			"gxp2000d.bin" => "GXP-2000",
			"gxp2000e.bin" => "GXP-2000",
			"gxp2010d.bin" => "GXP-2010",
			"gxp2010e.bin" => "GXP-2010",
			"gxp2020d.bin" => "GXP-2020",
			"gxp2020e.bin" => "GXP-2020",
			"gxp280e.bin" => "GXP-280",
			"gxv3000a.bin" => "GXV-3000");

$file = basename($path);

/* Identification */
if(substr($file, 0, 4) == 'boot') {
	$conn = pg_pconnect($dsn);
	pg_query("UPDATE users SET phone = 'Grandstream' WHERE gshostname = '" . pg_escape_string($_SERVER['REMOTE_ADDR']) . "'");
	syslog(LOG_DEBUG, "gsget.php: Phone startup at " . $_SERVER['REMOTE_ADDR']);
} elseif(isset($identify[$file])) {
	$conn = pg_pconnect($dsn);
	pg_query("UPDATE users SET phone = '" . $identify[$file] . "' WHERE gshostname = '" . pg_escape_string($_SERVER['REMOTE_ADDR']) . "'");
	syslog(LOG_DEBUG, "gsget.php: " . $identify[$file] . " identified at " . $_SERVER['REMOTE_ADDR']);
}

/* Downloads */
if($file == 'gs_phonebook.xml') {
	syslog(LOG_DEBUG, "gsget.php: Generating phonebook for " . $_SERVER['REMOTE_ADDR']);
	print get_GSPhonebook();
	exit;
} elseif(($file == 'ring1.bin') || ($file == 'ring2.bin') || ($file == 'ring3.bin')) {
	$conn = pg_pconnect($dsn);
	$query = sprintf("SELECT value FROM config WHERE key = 'general_%s' AND uid = (SELECT id FROM users WHERE gshostname = '%s')",
			$file, pg_escape_string($_SERVER['REMOTE_ADDR']));
	$result = pg_query($query);
	if(pg_num_rows($result)) {
		$ringtone = pg_fetch_result($result, 'value');
		if(is_readable("$ringtonedir/$ringtone.ring")) {
			syslog(LOG_DEBUG, "gsget.php: Serving '$ringtone.ring' as $file to " . $_SERVER['REMOTE_ADDR']);
			readfile("$ringtonedir/$ringtone.ring");
		} else 
			syslog(LOG_DEBUG, "gsget.php: Ring tone '$ringtone.ring' not found for " . $_SERVER['REMOTE_ADDR']);
		exit;
	}
} elseif($file == 'gs_screen.xml') {
	$conn = pg_pconnect($dsn);
	$query = sprintf("SELECT * FROM users WHERE gshostname = '%s'",
				pg_escape_string($_SERVER['REMOTE_ADDR']));
	$result = pg_query($query);
	$user = pg_fetch_array($result);
	unset($user['password']);

	$query = sprintf("SELECT ext,callerid,calleridname FROM states WHERE state = 2 AND ext IN
				(SELECT ext FROM users WHERE id IN
					(SELECT uid FROM config WHERE key LIKE 'callinfo_uri_%%' AND value IN
						(SELECT ext FROM users WHERE gshostname = '%s')))",
				pg_escape_string($_SERVER['REMOTE_ADDR']));
	$result = pg_query($query);
	$calls = pg_fetch_all($result);

	$path = sprintf("%s/%s", $idledir, dirname($path));
	$filename = sprintf("%s/gs_screen.xml.php", $path);
	if(is_readable("$filename")) {
		syslog(LOG_DEBUG, "gsget.php: Serving idle screen '$filename' for " . $_SERVER['REMOTE_ADDR']);
		include($filename);
	} else {
		syslog(LOG_DEBUG, "gsget.php: Idle screen '$filename' not found for " . $_SERVER['REMOTE_ADDR']);
	}
	exit;
}

$passname = $firmwaredir . "/" . $path;
if(is_readable($passname)) {
	syslog(LOG_DEBUG, "gsget.php: Serving $passname to " . $_SERVER['REMOTE_ADDR']);
	readfile($passname);
} else {
	syslog(LOG_DEBUG, "gsget.php: $passname not found for " . $_SERVER['REMOTE_ADDR']);
	header("HTTP/1.0 404 Not Found");
	echo "Sorry. No readable file found by that name.";
}
?>
