<?php
require_once("listobj.php");

require("ast_causes.php");

class history extends listobj {
	var $tablename = "history";

	function html_listheader() {
		$html  = "<tr class='header'><th>" . _("Time");
		$html .= "</th><th colspan=2>" . _("Caller");
		$html .= "</th><th colspan=2>" . _("Callee");
		$html .= "</th><th>" . _("State");
		$html .= "</th></tr>\n";
		
		return $html;
	}

	function get_extension($channel) {
		return substr($channel, 0, strrpos($channel, "-"));
	}

	function html_row($row) {
		global $ast_causes;

		$html = sprintf("<td>%s</td>", $row['stime']);
		$html .= sprintf("<td>%s</td>", $this->get_extension($row['src']));
		if($row['src_calleridname'] && strcasecmp($row['src_calleridname'], '<Unknown>'))
			$html .= sprintf("<td>%s<br/>&lt;%s&gt;", htmlspecialchars($row['src_calleridname']), htmlspecialchars($row['src_callerid']));
		else
			$html .= sprintf("<td>%s", htmlspecialchars($row['src_callerid']));
		if($_SESSION['ext'] && $row['src_callerid'] && strcasecmp($row['src_callerid'], '<Unknown>'))
			$html .= sprintf(" <a href='#' onclick='xajax_dial(\"%s\")'><img class='dial' src='images/dial.png' title='" . _("Dial") . "'></a>",
					 $row['src_callerid']);
		$html .= "</td>";
		$html .= sprintf("<td>%s</td>", $this->get_extension($row['dest']));
		if($row['dest_calleridname'] && strcasecmp($row['dest_calleridname'], '<Unknown>'))
			$html .= sprintf("<td>%s<br/>&lt;%s&gt;", htmlspecialchars($row['dest_calleridname']), htmlspecialchars($row['dest_callerid']));
		else
			$html .= sprintf("<td>%s", htmlspecialchars($row['dest_callerid']));
		if($_SESSION['ext'] && $row['dest_callerid'] && strcasecmp($row['dest_callerid'], '<Unknown>'))
			$html .= sprintf(" <a href='#' onclick='xajax_dial(\"%s\")'><img class='dial' src='images/dial.png' title='" . _("Dial") . "'></a>",
					 $row['dest_callerid']);
		$html .= "</td>";
		switch($row['state']) {
			case 0:
				$state = _("Ringing");
				break;
			case 1:
				$state = _("Talking");
				break;
			case 2:
				if(!$row['etime'])
					$state = _("Unknown");
				else
					$state = $row['ptime'] ? $row['duration'] : _("Not answered");
				break;
			default:
				$state = _("Unknown");
		}
		if($row['cause'] && ($row['cause'] != 16))	# Don't print "Normal clearing"
			$state = sprintf("%s<br/>%s (%s)", $state, isset($ast_causes[$row['cause']]) ? $ast_causes[$row['cause']] : '', $row['cause']);
		$html .= "<td>$state</td>";

		return $html;
	}

	function get_searchquery($string, $count = false) {
		$term = sprintf("ILIKE '%%%s%%'", pg_escape_string($string));
		$cond = "WHERE (src $term OR dest $term OR src_callerid $term OR src_calleridname $term OR dest_callerid $term OR dest_calleridname $term)";
		if(!$_SESSION['admin'])
			$cond .= sprintf(" AND (dest ILIKE '%s-%%' OR src ILIKE '%s-%%')", $_SESSION['ext'], $_SESSION['ext']);
		if($count)
			$query = "SELECT count(*) FROM history $cond";
		else {
			$query = "SELECT dest, src,
					src_calleridname, src_callerid,
					dest_calleridname, dest_callerid,
					stime::timestamp(0), ptime::timestamp(0),
					etime::timestamp(0), state, cause,
					(etime - ptime)::interval(0) AS duration
					FROM history $cond ORDER BY stime DESC";
		}
		return $query;
	}
}

?>
