<?php
require("config.php");

function get_config_value($uid, $key, $default = '') {
	$uid = (int)$uid;
	$key = pg_escape_string($key);
	if($uid)
		$query = "SELECT value FROM config WHERE uid = '$uid' and key = '$key'";
	else
		$query = "SELECT value FROM config WHERE uid IS NULL and key = '$key'";
	$result = pg_query($query);

	$value = pg_fetch_result($result, 'value');
	if(!$value)
		return $default;
	return $value;
}

/* Session setup */
$sessdir = ini_get('session.save_path') . "/gsphonebook";
if(!is_dir($sessdir))
	mkdir($sessdir, 0700);
ini_set('session.save_path', $sessdir);

$cookie_path = dirname($_SERVER['SCRIPT_NAME']);
$cookie_timeout = $session_timeout;
session_set_cookie_params($cookie_timeout, $cookie_path);

ini_set("session.gc_maxlifetime", $session_timeout);
ini_set("session.name", "GSPBSESSID");
session_start();

header("Content-type: text/html; charset=UTF-8");

$conn = pg_pconnect($dsn);

/* Localization */
$locale = get_config_value(0, 'LC_ALL');
putenv("LC_ALL=$locale");
setlocale(LC_ALL, $locale);
bindtextdomain("messages", "./locale");
bind_textdomain_codeset("messages", "utf-8");
textdomain("messages");

/* History cleanup on every 10th call*/
if(rand(0, 9) == 0) {
	$history_length = (float)get_config_value(Null, 'history_length');
	if($history_length)
		pg_query("DELETE FROM history WHERE stime < now() - '$history_length hours'::interval");
}

/* Login/Logout */
if(isset($_REQUEST['logout'])) {
	$error = _("Logout successful.");
	unset($_SESSION['username']);
}

if(!isset($_SESSION['username'])) {
	if(isset($_REQUEST['username'])) {
		$result = pg_query(sprintf("SELECT * FROM users WHERE username = '%s' AND password = '%s'",
					pg_escape_string($_REQUEST['username']),
					pg_escape_string($_REQUEST['password'])));
		if(pg_num_rows($result) == 1) {
			$row = pg_fetch_array($result);
			$_SESSION['uid'] = $row['id'];
			$_SESSION['username'] = $row['username'];
			$_SESSION['admin'] = ($row['admin'] == 't') ? true:false;
			$_SESSION['phone'] = $row['phone'];
			$_SESSION['gshostname'] = $row['gshostname'];
			$_SESSION['ext'] = $row['ext'];
			$_SESSION['callerid'] = $row['callerid'];

			#$result = pg_query("SELECT value FROM state WHERE key = 'last_update'");
			#$_SESSION['last_update'] = pg_fetch_result($result, 'value');
		} else
			$error = _("Wrong username or password!");
	}
}

if(!isset($_SESSION['username'])) {
	if(strpos($_SERVER['SCRIPT_NAME'], '.server.') === False) {
		include('login.php');
		exit;
	}
}

/* Xajax initialization */
require_once("$xajaxdir/xajax_core/xajax.inc.php");

$xajax = new xajax("index.server.php");
if($debug)
	$xajax->setFlag('debug', true);
?>
