<?php
require_once("prefobj.php");

class usercallinfopref extends prefobj {
	var $prefix = "up_callinfo";
	var $focus = "username";

	function usercallinfopref() {
		$this->uid = $_SESSION['uid'];
	}

	function get_htmlcallinfo($config, $nr) {
		$html .= "<div class='editlabel'>" . _("Allowed phone") . " " . ($nr + 1) . ":</div>";
		$html .= "<input type='text' name='callinfo_uri_$nr' value='" . htmlspecialchars($config["callinfo_uri_$nr"]) . "'><br/>";
		return $html;
	}

	function html_editEntry($config) {
		$html .= "<div class='status' id='status'></div>\n";
		$html .= "<h2>" . _("Callinfo configuration") . "</h2>";
		$html .= "<div class='prefexpl'>" . _("Here you can configure who is allowed to see your incoming calls.") . "</div>\n";
		$html .= "<div class='prefexpl'>" . _("Enter the SIP-URIs of the phones, e.g. 'SIP/phone'") . "</div>\n";
		$html .= "<div class='prefexpl'>" . _("The phone has to have at least firmware 1.1.6.37 to take advantage of this feature and must be configured to download a custom idle screen.") . "</div>\n";
		$html .= "<form id='pref' name='pref' action='#' onsubmit='xajax_" . $this->prefix . "_save(xajax.getFormValues(\"pref\"));return false'>\n";
		$html .= "<input type='hidden' name='id' value='$this->uid'>\n";

		$html .= "<span id='callinfo_conf'>";
		$html .= "<h3>" . _("Allowed phones") . "</h3>\n";
		$i = 0;
		while(True) {
			if(!isset($config["callinfo_uri_$i"]))
				break;
			$html .= $this->get_htmlcallinfo($config, $i);
			$i++;
		}
		$html .= $this->get_htmlcallinfo($config, $i);
		$html .= "</span>\n";
		$html .= "<input type='submit' value='" . _("Save") . "'/>\n";
		$html .= "</form>\n";

		return $html;
	}

	function save($data) {
		$data['id'] = (int)$data['id'];


		if($data['id'] != $this->uid) {
			$objResponse = new xajaxResponse();
			$objResponse->assign("status", "innerHTML", _("Error saving preferences. Wrong UserID."));
			return $objResponse;
		}

		$i = -1;
		$j = 0;
		$query = "BEGIN;";
		$query .= $this->get_deletequery();
		while(True) {
			$i++;
			if(!trim($data["callinfo_uri_$i"]))
				break;
			$query .= $this->get_savequery("callinfo_uri_$j", $data["callinfo_uri_$i"]);
			$j++;
		}
		$query .= "COMMIT;";
		pg_query($query);

		$objResponse = $this->display();
		$objResponse->assign("status", "innerHTML", _("Callinfo information saved."));
			
		return $objResponse;
	}


	function get_deletequery() {
		$query = "DELETE FROM config WHERE uid = '$this->uid' AND key LIKE 'callinfo_%';";
		return $query;
	}


	function get_selectquery() {
		$query = "SELECT * FROM config WHERE uid = '$this->uid' AND key LIKE 'callinfo_%'";
		return $query;
	}

}

?>
