<?php
require("init.php");

require("callinfo.common.php");

function callinfo_clear() {
	$objResponse = new xajaxResponse();
	$objResponse->assign("callinfo", "style.display", "none");

	return $objResponse;
}

function callinfo_check() {
	$objResponse = new xajaxResponse();
	$old_update = $_SESSION['last_update'];
	$result = pg_query("SELECT value FROM state WHERE key = 'last_update' AND value::timestamp > '$old_update'");
	if(pg_num_rows($result)) {
		$_SESSION['last_update'] = pg_fetch_result($result, 'value');
		$callinfo = html_callinfo();
		if($callinfo) {
			$objResponse->assign("callinfo", "innerHTML", html_callinfo());
			$objResponse->assign("callinfo", "style.display", "block");
			$objResponse->script('clearTimeout(clear_callinfo_t); clear_callinfo_t = setTimeout("xajax_callinfo_clear()", 30000)');
		}

		$objResponse = update_blf($objResponse, $old_update);
		#$objResponse->alert("last_update: " . $_SESSION['last_update']);
	}

	/* Handle next update */
	$callinfo_refresh = get_config_value(Null, 'callinfo_refresh');
	if($callinfo_refresh == '')
		$callinfo_refresh = 2;
	$callinfo_refresh = (float)$callinfo_refresh;
	$js = sprintf("last_update = '%s';", urlencode($_SESSION['last_update']));
	if($callinfo_refresh)
		$js .= sprintf("callinfo_refresh = %s; setTimeout('update_check()', callinfo_refresh);",
				$callinfo_refresh * 1000);
	$objResponse->script($js);
	return $objResponse;
}

define("STATE_UNKNOWN", 0);
define("STATE_UNREACHABLE", 1);
define("STATE_REACHABLE", 2);
define("STATE_UNREGISTERED", 3);
define("STATE_REGISTERED", 4);
define("STATE_INUSE", 5);
define("STATE_RINGING", 6);
define("STATE_INUSERINGING", 7);

$states = array(STATE_UNKNOWN => array('state-unknown.png', _("Unknown")),
		STATE_UNREACHABLE => array('state-unreachable.png', _("Unreachable")),
		STATE_REACHABLE => array('state-idle.png', _("Reachable")),
		STATE_UNREGISTERED => array('state-unregistered.png', _("Unregistered")),
		STATE_REGISTERED => array('state-idle.png', _("Registered")),
		STATE_INUSE => array('state-inuse.png', _("In use")),
		STATE_RINGING => array('state-ringing.png', _("Ringing")),
		STATE_INUSERINGING => array('state-inuse+ringing.png', _("In use & Ringing")));
	
$chans = array(1 => array('chan-inuse.png', _("Ringing")),
		2 => array('chan-ringing.png', _("Talking")));

function update_blf($objResponse, $old_update) {
	global $states, $chans;

	#
	# Save extensions that were updated in $updated_exts
	#
	$update = False;
	$query = sprintf("SELECT DISTINCT ext FROM states WHERE ts > '%s' AND ext IN ('%s')",
				$old_update, implode("','", $_SESSION['blfexts']));
	$result = pg_query($query);
	$result = pg_fetch_all($result);
	if(!$result) 	# No relevant BLF-updates since last call
		return $objResponse;

	$updated_exts = array();
	foreach($result as $row) {
		$updated_exts[] = $row['ext'];
	}

	#
	# Get all information for updated extensions
	#
	$query = sprintf("SELECT * FROM states WHERE ext IN ('%s') ORDER BY ext, channel",
				implode("','", $updated_exts));
	$result = pg_query($query);
	$result = pg_fetch_all($result);

	#
	# Update $_SESSION['blf_states'] with updated extension info
	#
	$newexts = array();
	foreach($result as $row) {
		if(!isset($newexts[$row['ext']])) {	# Clear old extension info if its the first occurance in this query
			$_SESSION['blf_states'][$row['ext']] = array('state' => STATE_UNKNOWN, 'channels' => array());
			$newexts[$row['ext']] = 1;
		}
		$ext = $_SESSION['blf_states'][$row['ext']];

		if($row['channel'] == '') {
			continue;
		}

		if($row['channel'] == 'connection') {
			switch($row['state']) {
				case 0:	# Unreachable
					$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_UNREACHABLE);
					break;
				case 1:	# Reachable
					$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_REACHABLE);
					break;
				case 2:	# Unregistered
					$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_UNREGISTERED);
					break;
				case 3:	# Registered
					$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_REGISTERED);
					break;
			}
			continue;
		} else if($row['channel'] == 'hint') {
        		#EXTENSION_REMOVED     = -2
		        #EXTENSION_DEACTIVATED = -1
		        #EXTENSION_NOT_INUSE   =  0
		        #EXTENSION_INUSE       =  1
		        #EXTENSION_BUSY        =  2
		        #EXTENSION_UNAVAILABLE =  4
		        #EXTENSION_RINGING     =  8
		        #EXTENSION_ONHOLD      = 16

			if(($row['state'] == -2) || ($row['state'] & 4)) {
				$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_UNREACHABLE);
			} else if($row['state'] == -1) {
				$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_UNREGISTERED);
			} else if($row['state'] == 0) {
				$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_REGISTERED);
			} else if(($row['state'] & 8) && ($row['state'] & 19)) {
				$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_INUSERINGING);
			} else if($row['state'] & 8) {
				$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_RINGING);
			} else if($row['state'] & 19) {
				$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_INUSE);
			} 
			continue;
		}


		$_SESSION['blf_states'][$row['ext']]['channels'][$row['channel']] = array('state' => $row['state'],
									'callerid' => $row['callerid'],
									'calleridname' => $row['calleridname'],
									'peerchannel' => $row['peerchannel']);
		if($ext['state'] == STATE_INUSERINGING)
			continue;
		switch($row['state']) {
			case 1:	# In use
				if($ext['state'] == STATE_RINGING)
					$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_INUSERINGING);
				else
					$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_INUSE);
				break;
			case 2:	# Ringing
				if($ext['state'] == STATE_INUSE)
					$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_INUSERINGING);
				else
					$_SESSION['blf_states'][$row['ext']]['state'] = max($ext['state'], STATE_RINGING);
				break;
		}
	}

	#
	# Look for each configured BLF button if it contains an extension that was updated.
	# If so execute xajax updates
	#
	$blf_ringing_prefix = get_config_value(Null, 'blf_ringing_prefix');
	$allow_pickup       = get_config_value(Null, 'blf_allow_pickup');
	$allow_steal        = get_config_value(Null, 'blf_allow_steal');
	$show_ringing       = get_config_value(Null, 'blf_show_ringing');
	$show_connected     = get_config_value(Null, 'blf_show_connected');

	foreach($_SESSION['blf'] as $blf) {
		if(!array_intersect($blf['ext'], $updated_exts))	# No updates for BLF button
			continue;

		$extid = htmlspecialchars(implode("_", $blf['ext']));
		$state = STATE_UNKNOWN;
		$channels = array();
		foreach($blf['ext'] as $ext) {
			if(!isset($_SESSION['blf_states'][$ext]))
				$_SESSION['blf_states'][$ext] = array('state' => 0, 'channels' => '');
			if((($_SESSION['blf_states'][$ext]['state'] == STATE_RINGING) && ($state == STATE_INUSE)) ||
				(($_SESSION['blf_states'][$ext]['state'] == STATE_INUSE) && ($state == STATE_RINGING)))
				$state = STATE_INUSERINGING;
			else
				$state = max($_SESSION['blf_states'][$ext]['state'], $state);
			if(is_array($_SESSION['blf_states'][$ext]['channels']))
				$channels = array_merge($channels, $_SESSION['blf_states'][$ext]['channels']);
		}

		$objResponse->assign("led-$extid", "src", "images/" . $states[$state][0]);
		$objResponse->assign("led-$extid", "title", $states[$state][1]);
		if($blf['phone']) {
			if(($state == STATE_RINGING) || ($state == STATE_INUSERINGING)) {
				$phone = $blf_ringing_prefix . $blf['phone'];
				$title = _("Pickup");
			} else {
				$phone = $blf['phone'];
				$title = _("Dial");
			}
			$objResponse->addEvent("dial-$extid", "onclick", "xajax_dial(\"$phone\")");
			$objResponse->assign("dial-$extid", "title", $title);
		}

		if($show_ringing || $show_connected) {
			$objResponse->clear("channels-$extid", "innerHTML");
			if($channels)
				foreach($channels as $id => $channel) {
					$link = '';
					if($channel['state'] == 1) {		# Connected
						if(!$show_connected)
							continue;
						if($allow_steal) {
							$link = sprintf("<a href='#' onclick='xajax_redirect(\"%s\")' title='%s'>",
									$channel['peerchannel'], _("Steal channel"));
						}
					} else if($channel['state'] == 2) {	# Ringing
						if(!$show_ringing)
							continue;
						if($allow_pickup) {
							$link = sprintf("<a href='#' onclick='xajax_redirect(\"%s\")' title='%s'>",
									$channel['peerchannel'], _("Pickup channel"));
						}
					}
					$str = sprintf("%s<img class='channel' src='images/%s' title='%s'> ",
							$link,
							$chans[$channel['state']][0],
							$chans[$channel['state']][1]);
					$str .= sprintf("&lt;%s&gt; %s",
							htmlspecialchars($channel['callerid']),
							htmlspecialchars($channel['calleridname']));
					if($link)
						$str .= "</a>";
					$str .= "<br/>";
					$objResponse->append("channels-$extid", "innerHTML", $str);
				}
		}
	}

	return $objResponse;
}

function html_callinfo() {
	$query = sprintf("SELECT stime::timestamp(0), src_calleridname, src_callerid, state FROM history
				WHERE dest LIKE '%s-%%' AND
				(stime > '%s'::timestamp - '30 seconds'::interval
				 OR ptime > '%s'::timestamp - '30 seconds'::interval
				 OR etime > '%s'::timestamp - '30 seconds'::interval)
				 ORDER BY stime",
				 $_SESSION['ext'],
				 $_SESSION['last_update'], $_SESSION['last_update'], $_SESSION['last_update']);
	$result = pg_query($query);
	$result = pg_fetch_all($result);
	if($result) {
		$html = "<table>";
		foreach($result as $row) {
			$html .= "<tr>";
			$html .= $row['stime'] . ":";
			//$html .= strftime("<td>%X:</td>", $row['stime']);
			$html .= sprintf("<td>" . _('Call from "%s" &lt;%s&gt;.') . "</td>",
					$row['src_calleridname'], $row['src_callerid']);
			switch($row['state']) {
				case 0:
					$html .= "<td><b>" . _("Ringing") . "</b></td>";
					break;
				case 1:
					$html .= "<td><b>" . _("Talking") . "</b></td>";
					break;
				case 2:
					$html .= "<td><b>" . _("Hangup") . "</b></td>";
					break;
			}
			$html .= "</tr>\n";
		}
		$html .= "</table>";
	} else
		$html = "";

	return $html;
}

$xajax->processRequest();
?>
