#!/usr/bin/env python

import time
import socket
import datetime
import psycopg2 as db
import psycopg2.extras
#from mx.DateTime import *

import pprint

import config

dbcon = db.connect(config.dsn)
dbcon.set_isolation_level(0)
cur = dbcon.cursor(cursor_factory = psycopg2.extras.DictCursor)

update   = False
registry = {}
calls    = {}

#gs_idle_updated = {}
gs_idle_update  = {}

def get_config_value(key):
    """
    Get value from config option from DB.
    """

    cur.execute("SELECT value FROM config WHERE key = %s", (key,))
    result = cur.fetchone()
    if result:
        return result['value']

    raise ValueError('config-key not found: %s' % key)

def get_calleridname(callerid, calleridname):
    cur.execute("SELECT lastname, firstname, info FROM phonebook WHERE phonenumber = %s", (callerid,))
    if cur.rowcount:
        row = cur.fetchone()
        calleridname = ''
        if row['lastname']:
            calleridname = row['lastname']
        if row['firstname']:
            if calleridname:
                calleridname += ", "
            calleridname += row['firstname']
        if row['info']:
            if calleridname:
                calleridname += " - "
            calleridname += row['info']
    return calleridname

#def peers_idle_update(extension, hangup = False):
def peers_idle_update(extension):
    cur.execute("SELECT value FROM config WHERE key LIKE 'callinfo_uri_%%' AND uid in (SELECT id from users WHERE ext = %s)",
                    (extension,))
    if cur.rowcount:
        result = cur.fetchall()
        for row in result:
            gs_idle_update[row['value']]  = True
    #if hangup and gs_idle_updated.has_key(extension):
    #    gs_idle_update[extension] = True

STATE_UNREACHABLE  = 0
STATE_REACHABLE    = 1
STATE_UNREGISTERED = 2
STATE_REGISTERED   = 3

class States:
    states = {}

    def __repr__(self):
        return self.states.__repr__()

    def get_state(self, channel):
        extension = self.get_extension(channel)
        return self.states.setdefault(extension, {})

    def get_idstate(self, channel):
        state = self.get_state(channel)
        return state.setdefault(channel, {'peers': []})

    def get_extension(self, channel):
        """
        Strip trailing random stuff of channel to get extension.
        """
        return channel[:channel.rfind('-')]

    def create(self, chan):
        global update

        extension = self.get_extension(chan['channel']);
        state = self.get_idstate(chan['channel'])
        state['state'] = chan['state']

	print "create", chan['channel'], chan['state']
        cur.execute("UPDATE states SET state = %s, ts = now() WHERE channel = %s",
                    (chan['state'], chan['channel']))
        if not cur.rowcount:
            cur.execute("INSERT INTO states (ext, state, channel, ts) VALUES (%s, %s, %s, now())",
                        (extension, chan['state'], chan['channel']))
        update = True

    def remove(self, chan):
        global update

        self.get_idstate(chan['channel'])
        extension = self.get_extension(chan['channel'])
        del self.states[extension][chan['channel']]
        #peers_idle_update(extension, hangup = True)
        peers_idle_update(extension)

        cur.execute("SELECT DISTINCT ext FROM states WHERE channel = %s OR peerchannel = %s",
                    (chan['channel'], chan['channel']))
        if cur.rowcount:
            result = cur.fetchall()

            cur.execute("DELETE FROM states WHERE channel = %s OR peerchannel = %s", (chan['channel'], chan['channel']))

            for row in result:
                cur.execute("UPDATE states SET ts = now() WHERE ext = %s", (row['ext'],))
                if not cur.rowcount:
                    cur.execute("INSERT INTO states (ext, ts) VALUES (%s, now())", (row['ext'],))
            update = True

    def dial(self, src, dest):
        global update

        src_chan = self.get_idstate(src['channel'])
        src_chan['peers'] += [dest]
        src_chan['state']  = CHAN_INUSE
        dest_chan = self.get_idstate(dest['channel'])
        dest_chan['peers'] += [src]
        dest_chan['state']  = CHAN_RINGING

        
        cur.execute("DELETE FROM states WHERE channel = %s AND peerchannel IS NULL",
                    (src['channel'],))
        cur.execute("INSERT INTO states (ext, state, channel, peerchannel, callerid, calleridname, ts)"
                        " VALUES (%s, %s, %s, %s, %s, %s, now())",
                        (self.get_extension(src['channel']),
                         src_chan['state'], src['channel'],
                         dest['channel'],
                         dest['callerid'], dest['calleridname']))
        cur.execute("DELETE FROM states WHERE channel = %s AND peerchannel IS NULL",
                    (dest['channel'],))
        cur.execute("INSERT INTO states (ext, state, channel, peerchannel, callerid, calleridname, ts)"
                        " VALUES (%s, %s, %s, %s, %s, %s, now())",
                        (self.get_extension(dest['channel']),
                         dest_chan['state'], dest['channel'],
                         src['channel'],
                         src['callerid'], src['calleridname']))
        update = True

    def link(self, src, dest):
        global update

        src_chan = self.get_idstate(dest['channel'])
        src_chan['state']  = CHAN_INUSE
        dest_chan = self.get_idstate(dest['channel'])
        dest_chan['state']  = CHAN_INUSE

        cur.execute("UPDATE states SET state = %s, ts = now() WHERE channel = %s AND peerchannel = %s",
                    (src_chan['state'], src['channel'], dest['channel']))
        if not cur.rowcount:
            cur.execute("INSERT INTO states (ext, state, channel, peerchannel, callerid, calleridname, ts)"
                        " VALUES (%s, %s, %s, %s, %s, %s, now())",
                        (self.get_extension(src['channel']),
                         src_chan['state'], src['channel'],
                         dest['channel'],
                         dest['callerid'], dest['calleridname']))

        cur.execute("UPDATE states SET state = %s, ts = now() WHERE channel = %s AND peerchannel = %s",
                    (dest_chan['state'], dest['channel'], src['channel']))
        if not cur.rowcount:
            cur.execute("INSERT INTO states (ext, state, channel, peerchannel, callerid, calleridname, ts)"
                        " VALUES (%s, %s, %s, %s, %s, %s, now())",
                        (self.get_extension(dest['channel']),
                         dest_chan['state'], dest['channel'],
                         src['channel'],
                         src['callerid'], src['calleridname']))
        update = True

    def set_callerid(self, chan):
        global update

        state = self.get_idstate(chan['channel'])
        cur.execute("UPDATE states SET callerid = %s, calleridname = %s, ts = now() WHERE peerchannel = %s",
                    (chan['callerid'], chan['calleridname'], chan['channel']))
        if cur.rowcount:
            update = True

    def set_connection(self, extension, status):
        global update

        state = self.get_state('%s-' % extension)
	print state
        if status == 'Registered':
            state['connection'] = STATE_REGISTERED
        elif status == 'Unregistered':
            state['connection'] = STATE_UNREGISTERED
        elif status == 'Reachable':
            state['connection'] = STATE_REACHABLE
        else:
            # 'Unreachable', 'Lagged', 'Request Sent'
            state['connection'] = STATE_UNREACHABLE

        cur.execute("UPDATE states SET state = %s, ts = now() WHERE ext = %s AND channel = 'connection'",
                    (state['connection'], extension))
        if not cur.rowcount:
            cur.execute("INSERT INTO states (ext, state, channel, ts) VALUES (%s, %s, 'connection', now())",
                        (extension, state['connection']))
        update = True

    def set_extensionStatus(self, extension, status):
        global update

        #EXTENSION_REMOVED     = -2
        #EXTENSION_DEACTIVATED = -1
        #EXTENSION_NOT_INUSE   =  0
        #EXTENSION_INUSE       =  1
        #EXTENSION_BUSY        =  2
        #EXTENSION_UNAVAILABLE =  4
        #EXTENSION_RINGING     =  8
        #EXTENSION_ONHOLD      = 16

        state = self.get_state('%s-' % extension)
        state['hint'] = status
        cur.execute("UPDATE states SET state = %s, ts = now() WHERE ext = %s AND channel = 'hint'",
                    (state['hint'], extension))
        if not cur.rowcount:
            cur.execute("INSERT INTO states (ext, state, channel, ts) VALUES (%s, %s, 'hint', now())",
                        (extension, state['hint']))
        update = True


CHAN_IDLE    = 0
CHAN_INUSE   = 1
CHAN_RINGING = 2

class Channels:
    channels = {}
    
    def __repr__(self):
        return self.channels.__repr__()

    def get_channel(self, channel):
        return self.channels.setdefault(channel, {'channel': channel,
                                                  'id': None,
                                                  'callerid': None,
                                                  'calleridname': None})

    def create(self, ev):
        channel = ev['Channel']
        chan = self.get_channel(channel)
        chan['id']           = ev['Uniqueid']
        chan['callerid']     = ev.get('CallerID', '')
        if not chan['callerid']:
            chan['callerid'] = ev.get('CallerIDNum', '')
        chan['calleridname'] = get_calleridname(chan['callerid'], ev['CallerIDName'])
	if ev.has_key('State'):
            state = ev['State']
        else:	# Hack for Asterisk > 1.4
            state = ev['ChannelStateDesc']
        if state == 'Ringing':
            chan['state'] = CHAN_RINGING
            extension = channel[:channel.rfind('-')]
            peers_idle_update(extension)
        elif state == 'Ring':
            chan['state'] = CHAN_INUSE
        elif state == 'Up':
            chan['state'] = CHAN_INUSE
            extension = channel[:channel.rfind('-')]
            peers_idle_update(extension)
        else:
            chan['state'] = CHAN_IDLE
        states.create(chan)

    def set_callerid(self, ev):
        chan = self.get_channel(ev['Channel'])
        chan['callerid']     = ev.get('CallerID', '')
        if not chan['callerid']:
            chan['callerid'] = ev.get('CallerIDNum', '')
        chan['calleridname'] = get_calleridname(chan['callerid'], ev['CallerIDName'])
        states.set_callerid(chan)

        return chan['callerid'], chan['calleridname']

    def hangup(self, ev):
        channel = ev['Channel']
        chan = self.get_channel(channel)
        states.remove(chan)
        del self.channels[channel]

    def dial(self, src, dest):
        src_chan  = self.get_channel(src)
        src_chan['state']  = CHAN_INUSE
        dest_chan = self.get_channel(dest)
        dest_chan['state'] = CHAN_RINGING
        states.dial(src_chan, dest_chan)

    def link(self, src, dest):
        src  = self.get_channel(src)
        src['state']    = CHAN_INUSE
        dest = self.get_channel(dest)
        dest['state']    = CHAN_INUSE
        states.link(src, dest)
        

CALL_RINGING = 0
CALL_TALKING = 1
CALL_HANGUP  = 2

class Calls:
    calls = {}

    def __repr__(self):
        return self.calls.__repr__()

    def get_call(self, dest):
        return self.calls.setdefault(dest, {})
            
    def create(self, ev):
        global update

        if ev.has_key('Source'):
            src = ev['Source']
        else:
            src = ev['Channel']
        #srcid  = ev['SrcUniqueID']
        dest   = ev['Destination']
        #destid = ev['DestUniqueID']

        call = self.get_call(dest)
        channels.dial(src, dest)
        call['stime'] = datetime.datetime.now()
        call['state'] = CALL_RINGING

        src_chan  = channels.get_channel(src)
        dest_chan = channels.get_channel(dest)
        cur.execute("INSERT INTO history (src, dest, stime, src_callerid, src_calleridname,"
                    " dest_callerid, dest_calleridname, state)"
                    " VALUES (%s, %s, now(), %s, %s, %s, %s, %s)",
                    (src, dest, src_chan['callerid'], src_chan['calleridname'],
                     dest_chan['callerid'], dest_chan['calleridname'], call['state']))
        update = True

    def link(self, ev):
        global update

        src    = ev['Channel1']
        dest   = ev['Channel2']
        #destid = ev['Uniqueid2']
        call = self.get_call(dest)
        channels.link(src, dest)
        call['ptime'] = datetime.datetime.now()
        call['state'] = CALL_TALKING

        cur.execute("UPDATE history SET ptime = now(), state = %s WHERE ptime IS NULL AND etime IS NULL AND src = %s AND dest = %s",
                    (call['state'], src, dest))
        if not cur.rowcount:
            src_chan  = channels.get_channel(src)
            dest_chan = channels.get_channel(dest)
            cur.execute("INSERT INTO history (src, dest, stime, ptime, src_callerid, src_calleridname,"
                        " dest_callerid, dest_calleridname, state)"
                        " VALUES (%s, %s, now(), now(), %s, %s, %s, %s, %s)",
                        (src, dest, src_chan['callerid'], src_chan['calleridname'],
                         dest_chan['callerid'], dest_chan['calleridname'], call['state']))
        update = True

    def unlink(self, ev):
        global update

        src    = ev['Channel1']
        dest   = ev['Channel2']
        #destid = ev['Uniqueid2']
        call = self.get_call(dest)
        call['etime'] = datetime.datetime.now()
        call['state'] = CALL_HANGUP

        cur.execute("UPDATE history SET etime = now(), state = %s WHERE ptime IS NOT NULL and etime IS NULL AND dest = %s",
                    (call['state'], dest))
        update = True

    def hangup(self, ev):
        global update

        if ev['Channel'].find("<") != -1:                               # Bad hack, because we ignore channel renames
            ev['Channel'] = ev['Channel'][:ev['Channel'].rfind("<")]    # Strip <MASQ> and <ZOMBIE>
        #destid = ev['Uniqueid']
        channel = ev['Channel']
        if ev.has_key('Cause'):
            cause = ev['Cause']
        else:
            # DialStatus: CANCEL, ANSWER
            cause = 16	# NORMAL_CALL_CLEARING
        cur.execute("UPDATE history SET etime = now(), state = %s, cause = %s WHERE (src = %s OR dest = %s) AND etime IS NULL",
                    (CALL_HANGUP, cause, channel, channel))
        if cur.rowcount:
            update = True

        if self.calls.has_key(channel):    # Try to hang up if channel is a valid destination
            call = self.get_call(channel)
            # call['etime'] = now()
            # call['state'] = CALL_HANGUP
            del self.calls[channel]

        channels.hangup(ev)

    def set_callerid(self, ev):
        global update

        callerid, calleridname = channels.set_callerid(ev)
        #id = ev['Uniqueid']
        channel = ev['Channel']

        cur.execute("UPDATE history SET src_callerid = %s, src_calleridname = %s WHERE src = %s AND etime IS NULL",
                    (callerid, calleridname, channel))
        if cur.rowcount:
            update = True
        cur.execute("UPDATE history SET dest_callerid = %s, dest_calleridname = %s WHERE dest = %s AND etime IS NULL",
                    (callerid, calleridname, channel))
        if cur.rowcount:
            update = True

class AMI:
    """
    Asterisk Manager Interface class
    """
    fd = None
    buffer = ''

    def __init__(self):
        self.login()

    def login(self):
        """
        Login to AMI. Get info from database.
        """
        ami_host = get_config_value('ami_host')
        ami_port = int(get_config_value('ami_port'))

        try:
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.connect((ami_host, ami_port))
            self.fd = s.makefile()
        except socket.error, e:
            print "Could not connect to AMI: %s:%s" % (ami_host, ami_port)
            raise e

        # Get 'Asterisk Call Manager/1.0'
        ret = self.fd.readline()
	if ret[:22] != 'Asterisk Call Manager/' or ret[25:] != '\r\n':
            raise Exception("Did not receive Asterisk Call Manager greeting.")

        ami_login = get_config_value('ami_login')
        ami_password = get_config_value('ami_password')

        self.fd.write('Action: Login\r\nUsername: %s\r\nSecret: %s\r\nEvents: on\r\n\r\n' % (ami_login, ami_password))
        self.fd.flush()

        ev = self.get_event()
        if ev['Message'] != 'Authentication accepted':
            raise Exception("Asterisk Manager Interface - Authentication failed.")

    def send_command(self, command):
        query = 'Action: Command\r\nCommand: %s\r\n\r\n' % command
        if config.debug: print query
        self.fd.write(query)
        self.fd.flush()

    def get_event(self):
        """
        Wait for an AMI event, put it in a dictionary and return it.
        But first, send SIP Notifications for idle screen updates.
        """
        #global gs_idle_updated, gs_idle_update
        global gs_idle_update

        if gs_idle_update:
            peers = ''
            for peer in gs_idle_update:
		if peer[:4] == 'SIP/':
                    peers += ' %s' % peer[4:]
                    #gs_idle_updated[peer] = True
            gs_idle_update = {}
            if peers:
                self.send_command('sip notify %s %s' % (config.idle_sipnotify, peers))

        ev = {}
        line = self.fd.readline()
        if line == '':
                print "Possible disconnection."
                raise socket.error()

        line = line[:-2]  # Strip trailing '\r\n'
        while line != '':
            try:
                key, value = line.split(': ', 1)
                ev[key] = value
            except ValueError:
                if config.debug: print "Line not in key, value format: %s" % line
            line = self.fd.readline()[:-2]
        
        return ev


def mainloop(ami):
    global update

    cur.execute("BEGIN")
    cur.execute("DELETE FROM state WHERE key = 'last_update'");
    cur.execute("INSERT INTO state (key, value) VALUES ('last_update', now())");
    cur.execute("DELETE FROM states");
    cur.execute("COMMIT")
    while 1:
        ev = ami.get_event()
        if not ev.has_key('Event'):
            if config.debug: print ev
            continue

        if ev['Event'] == 'Newexten':   # We don't need this.
            continue

        if config.debug:
            print "Event:", pprint.pformat(ev)

        # Asterisk shutdown
        if ev['Event'] == 'Shutdown':
            print "Asterisk server shutdown. Sleeping 10 seconds before reconnecting."
            time.sleep(10)
            return

        #
        # Channel events
        #
        # Incoming calls
        elif ev['Event'] in ('Newchannel', 'Newstate'):     # Permission: read = call
            channels.create(ev)
        # Change in CallerID
        elif ev['Event'] == 'NewCallerid':  # Permission: read = call
            calls.set_callerid(ev)
        # Channel hangup
        elif ev['Event'] == 'Hangup':       # Permission: read = call
            calls.hangup(ev)    # Might have to cancel call first
        #
        # Call events
        #
        # Dial event
        elif ev['Event'] == 'Dial':         # Rermission: read = call
            if ev.has_key('SubEvent') and ev['SubEvent'] == 'End':	# Asterisk 1.6
                calls.hangup(ev)
            else:
                calls.create(ev)
        # Call connected
        elif ev['Event'] == 'Link':         # Rermission: read = call
            calls.link(ev)
	elif ev['Event'] == 'Bridge' and ev['Bridgestate'] == 'Link':
            calls.link(ev)
        # Call disconnected
        elif ev['Event'] == 'Unlink':       # Permission: read = call
            calls.unlink(ev)

        # Status update of (SIP) peers
        elif ev['Event'] == 'PeerStatus':   # Permission: read = system
            extension = ev['Peer']
            status = ev['PeerStatus']
            states.set_connection(extension, status)
        # Outgoing SIP-Registrations
        elif ev['Event'] == 'Registry':
            """
            channel = ev['Channel']
            domain  = ev['Domain']
            if not registry.has_key(channel):
                registry[channel] = {}
            if not registry[channel].has_key(domain):
                registry[channel][domain] = {}
            registry[channel][domain] = ev['Status']
            continue
            """
            extension = ev['Domain']
            status = ev['Status']
            states.set_connection(extension, status)
        elif ev['Event'] == 'ExtensionStatus':
            extension = 'hint/%s' % ev['Exten']
            status = ev['Status']
            states.set_extensionStatus(extension, status)


        if update:
            cur.execute("UPDATE state SET value = now() WHERE key = 'last_update'");
            update = False

        if config.debug:
            #cur.execute("SELECT * FROM history WHERE stime > now() - '1 minute'::interval")
            #print "history:", cur.fetchall()
            #cur.execute("SELECT * FROM states WHERE ts > now() - '1 minute'::interval")
            #print "states:", cur.fetchall()
            print "Calls:", pprint.pformat(calls)
            print "Channels:", pprint.pformat(channels)
            print "Registry:", pprint.pformat(registry)
            print "States:", pprint.pformat(states)
            
    

if __name__ == '__main__':
    while 1:
        try:
            ami      = AMI()
            channels = Channels()
            calls    = Calls()
            states   = States()
            mainloop(ami)
        except (socket.error, KeyError), e:
            import traceback
            traceback.print_exc()
            time.sleep(10)
