/*
 * Copyright (C) 2011 Lars Bensmann
 *
 * This file is released under the GPLv2.
 */

package de.almosthappy.gssync.authenticator;

import de.almosthappy.gssync.Constants;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;

/**
 * Service to handle Account authentication. It instantiates the authenticator
 * and returns its IBinder.
 */
public class AuthenticationService extends Service {
    private static final String TAG = "AuthenticationService";
    private Authenticator mAuthenticator;

    @Override
    public void onCreate() {
    	if(Constants.debug) {
    		Log.i(TAG, "onCreate()");
    	}
        if (Log.isLoggable(TAG, Log.VERBOSE)) {
            Log.v(TAG, "GSSyncAdapter Authentication Service started.");
        }
        mAuthenticator = new Authenticator(this);
    }

    @Override
    public void onDestroy() {
    	if(Constants.debug) {
    		Log.i(TAG, "onDestroy()");
    	}
        if (Log.isLoggable(TAG, Log.VERBOSE)) {
            Log.v(TAG, "GSSyncAdapter Authentication Service stopped.");
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
    	if(Constants.debug) {
    		Log.i(TAG, "onBind()");
    	}
        if (Log.isLoggable(TAG, Log.VERBOSE)) {
            Log.v(TAG,
                "getBinder()...  returning the AccountAuthenticator binder for intent "
                    + intent);
        }
        return mAuthenticator.getIBinder();
    }
}
