/*
 * Copyright (C) 2011 Lars Bensmann
 *
 * This file is released under the GPLv2.
 */

package de.almosthappy.gssync.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

import org.xml.sax.helpers.DefaultHandler;

import android.sax.Element;
import android.sax.EndElementListener;
import android.sax.EndTextElementListener;
import android.sax.RootElement;
import android.util.Xml;

public class GSSaxParser extends DefaultHandler {
	final URL Url;
	final String username;
	final String pwhash;
	
	public GSSaxParser(String Url, String username, String pwhash) throws MalformedURLException {
		this.Url = new URL(Url);
		this.username = username;
		this.pwhash = pwhash;
	}
	protected InputStream getInputStream() {
		try {
			String postData = URLEncoder.encode("username", "UTF-8") + "=" + URLEncoder.encode(username, "UTF-8");
			postData += "&" + URLEncoder.encode("hash", "UTF-8") + "=" + URLEncoder.encode(pwhash, "UTF-8");
			URLConnection conn = Url.openConnection();
			conn.setDoOutput(true);
			OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
			wr.write(postData);
			wr.flush();
			InputStream is = conn.getInputStream();
			return is;
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
	
	public List<Contact> parse() {
		final Contact currentContact = new Contact();
		RootElement root = new RootElement("AddressBook");
		final List<Contact> contacts = new ArrayList<Contact>();
		Element c = root.getChild("Contact");
		c.setEndElementListener(new EndElementListener() {
			public void end() {
				contacts.add((currentContact).copy());
			}
		});
		c.getChild("LastName").setEndTextElementListener(new EndTextElementListener() {
			public void end(String body) {
				currentContact.setLastName(body);
			}
		});
		c.getChild("FirstName").setEndTextElementListener(new EndTextElementListener() {
			public void end(String body) {
				currentContact.setFirstName(body);
			}
		});
		c.getChild("Info").setEndTextElementListener(new EndTextElementListener() {
			public void end(String body) {
				currentContact.setInfo(body);
			}
		});
		c.getChild("Id").setEndTextElementListener(new EndTextElementListener() {
			public void end(String body) {
				currentContact.setId(body);
			}
		});
		c.getChild("Phone").getChild("phonenumber").setEndTextElementListener(new EndTextElementListener() {
			public void end(String body) {
				currentContact.setPhonenumber(body);
			}
		});
		
		try {
			Xml.parse(this.getInputStream(), Xml.Encoding.ISO_8859_1, root.getContentHandler());
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return contacts;
	}
}