/*
 * Copyright (C) 2011 Lars Bensmann
 *
 * This file is released under the GPLv2.
 */

package de.almosthappy.gssync.platform;

import java.util.List;

import android.accounts.Account;
import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.ContactsContract.Data;
import android.provider.ContactsContract.RawContacts;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.provider.ContactsContract.CommonDataKinds.StructuredName;
import android.util.Log;
import de.almosthappy.gssync.Constants;
import de.almosthappy.gssync.client.Contact;


/**
 * Class for managing contacts sync related mOperations
 */
public class ContactManager {
    private static final String TAG = "ContactManager";

    /**
     * Synchronize raw contacts
     * 
     * @param context The context of Authenticator Activity
     * @param account The username for the account
     * @param users The list of users
     */
    public static synchronized void syncContacts(Context context,
        Account account, List<Contact> contacts) {
    	String DisplayName;
        long rawContactId = 0;
        final ContentResolver resolver = context.getContentResolver();
        final BatchOperation batchOperation =
            new BatchOperation(context, resolver);
        final Uri rawContactUri = RawContacts.CONTENT_URI.buildUpon()
        		.appendQueryParameter(RawContacts.ACCOUNT_NAME, account.name)
        		.appendQueryParameter(RawContacts.ACCOUNT_TYPE, account.type)
        		.build();
        //android.os.Debug.waitForDebugger();
        if(Constants.debug) {
        	Log.i(TAG, "In SyncContacts");
        }
        
        //getAllContacts(resolver, rawContactUri);
        resolver.delete(rawContactUri.buildUpon().appendQueryParameter(ContactsContract.CALLER_IS_SYNCADAPTER, "true").build(), null, null);
        for (final Contact contact : contacts) {
        	DisplayName = contact.getDisplayName();
        	if(Constants.debug) {
        		Log.i(TAG, "Name: " + DisplayName);
        	}
        	
            // Check to see if the contact needs to be inserted or updated
        	rawContactId = lookupRawContact(resolver, rawContactUri, DisplayName);
        	//Log.i(TAG, "rawContactUri: " + rawContactId);
        	if(rawContactId == 0) {
        		if(Constants.debug) {
        			Log.i("TAG", "Adding contact: " + contact);
        		}
        		addContact(rawContactUri, contact, batchOperation);
        	} else {
        		if(Constants.debug) {
        			Log.i("TAG", "Adding contact data: " + contact);
        		}
        		addContactData(rawContactId, contact, batchOperation);
        	}

        /*
        if(contacts.isEmpty())
        	return;
        if(contacts.get(0).getId() == null)
            resolver.delete(rawContactUri.buildUpon().appendQueryParameter(ContactsContract.CALLER_IS_SYNCADAPTER, "true").build(), null, null);
        Log.i(TAG, "id: " + lookupRawContactByDataId(resolver, "1"));
        Log.i(TAG, "id: " + lookupSourceId(resolver, rawContactUri, lookupRawContactByDataId(resolver, "1")));

        for (final Contact contact : contacts) {
        	LastName = contact.getLastName();
        	FirstName = contact.getFirstName();
        	DisplayName = contact.getDisplayName();        	
        	Log.i(TAG, "Name: " + FirstName + " " + LastName + " / " + DisplayName);
        	
            // Check to see if the contact needs to be inserted or updated
        	rawContactId = lookupRawContact(resolver, rawContactUri, DisplayName);
        	//Log.i(TAG, "rawContactUri: " + rawContactId);
        	if(rawContactId == 0) {
        		Log.i("TAG", "Adding contact: " + contact);
        		addContact(rawContactUri, syncId, contact, batchOperation);
        	} else {
        		updateContact(resolver, rawContactId, syncId, contact, batchOperation);
        		//addContactData(rawContactId, syncId, contact, batchOperation);
        	}
        	*/
        	/*
            if (rawContactId != 0) {
                if (!user.isDeleted()) {
                    // update contact
                    updateContact(context, resolver, account, user,
                        rawContactId, batchOperation);
                } else {
                    // delete contact
                    deleteContact(context, rawContactId, batchOperation);
                }
            } else {
                // add new contact
                Log.d(TAG, "In addContact");
                if (!user.isDeleted()) {
                    addContact(context, account, user, batchOperation);
                }
            }
            */
            // A sync adapter should batch operations on multiple contacts,
            // because it will make a dramatic performance difference.
            if (batchOperation.size() >= 50) {
                batchOperation.execute();
            }
            
        }
        batchOperation.execute();
    }


    /**
     * Adds a single contact to the platform contacts provider.
     * 
     * @param context the Authenticator Activity context
     * @param accountName the account the contact belongs to
     * @param user the sample SyncAdapter User object
     */
    
    //private static void addContact(Uri rawContactUri, double syncId, Contact contact, BatchOperation batchOperation) {
    private static void addContact(Uri rawContactUri, Contact contact, BatchOperation batchOperation) {
    	   	
   		ContentProviderOperation.Builder cpob = ContentProviderOperation.newInsert(rawContactUri);
   		cpob.withValue(RawContacts.SOURCE_ID, contact.getDisplayName());
   		batchOperation.add(cpob.build());
    		
   		final int backId = batchOperation.size() - 1;
   		cpob = ContentProviderOperation.newInsert(Data.CONTENT_URI);
   		cpob.withValueBackReference(Data.RAW_CONTACT_ID, backId);
   		cpob.withValue(Data.MIMETYPE, StructuredName.CONTENT_ITEM_TYPE);
   		cpob.withValue(StructuredName.DISPLAY_NAME, contact.getDisplayName());
   		cpob.withValue(StructuredName.FAMILY_NAME, contact.getLastName());
   		cpob.withValue(StructuredName.GIVEN_NAME, contact.getFirstName());
   		batchOperation.add(cpob.build());
    		
   		cpob = ContentProviderOperation.newInsert(Data.CONTENT_URI);
   		cpob.withValueBackReference(Data.RAW_CONTACT_ID, backId);
   		cpob.withValue(Data.MIMETYPE, Phone.CONTENT_ITEM_TYPE);
   		cpob.withValue(Phone.NUMBER, contact.getPhonenumber());
   		String info = contact.getInfo();
   		if(info != null) {
   			if(info != "") {
   				cpob.withValue(Phone.TYPE, Phone.TYPE_CUSTOM);
   				cpob.withValue(Phone.LABEL, info);
   			} else
   				cpob.withValue(Phone.TYPE, Phone.TYPE_MAIN);
   			cpob.withValue(Data.SYNC1, contact.getId());
   		} else {
   			cpob.withValue(Phone.TYPE, Phone.TYPE_MAIN);
   		}
   		//cpob.withValue(Data.SYNC2, syncId);
   		batchOperation.add(cpob.build());
    }

    private static void addContactData(long rawContactId, Contact contact, BatchOperation batchOperation) {
    	final String info = contact.getInfo();
    	ContentProviderOperation.Builder cpob = ContentProviderOperation.newInsert(Data.CONTENT_URI);
    	cpob.withValue(Data.RAW_CONTACT_ID, rawContactId);
    	cpob.withValue(Data.MIMETYPE, Phone.CONTENT_ITEM_TYPE);
    	cpob.withValue(Phone.NUMBER, contact.getPhonenumber());
    	if(info != null) {
    		if(info != "") {
    			cpob.withValue(Phone.TYPE, Phone.TYPE_CUSTOM);
    			cpob.withValue(Phone.LABEL, info);
    		} else
    			cpob.withValue(Phone.TYPE, Phone.TYPE_MAIN);
    		cpob.withValue(Data.SYNC1, contact.getId());
    	} else {
    		cpob.withValue(Phone.TYPE, Phone.TYPE_MAIN);
    	}
    	batchOperation.add(cpob.build());
    }

    /*
    private static List<Contact> getAllContacts(ContentResolver resolver, Uri rawContactUri) {
    	final List<Contact> contacts = new ArrayList<Contact>();
    	final Contact currentContact = new Contact();
    	final Cursor c = resolver.query(RawContactsEntity.CONTENT_URI,
    			new String[]{RawContacts._ID, Data._ID, Data.MIMETYPE, Data.DATA1, Data.DATA2, Data.DATA3},
    			null, null,
    			RawContacts._ID + "," + Data.MIMETYPE + "='" + StructuredName.CONTENT_ITEM_TYPE + "'");
    	String mime;
    	try {
    		while (c.moveToNext()) {
    			Log.i(TAG, "c: " + c);
    			Log.i(TAG, "Data._ID: " + c.getLong(0));
    			mime = c.getString(2);
    			Log.i(TAG, "MIME: " + mime);
    			Log.i(TAG, "MIME: " + StructuredName.CONTENT_ITEM_TYPE + " / " + Phone.CONTENT_ITEM_TYPE);
    			Log.i(TAG, "mtest: " + (String.valueOf(mime) == String.valueOf(StructuredName.CONTENT_ITEM_TYPE)));
    			if(mime.equals(StructuredName.CONTENT_ITEM_TYPE)) {
    				Log.i(TAG, "FIRST_NAME: " + c.getString(4));
    				Log.i(TAG, "FAMILY_NAME: " + c.getString(5));
    				currentContact.setFirstName(c.getString(4));
    				currentContact.setLastName(c.getString(5));
    			} else if(mime.equals(Phone.CONTENT_ITEM_TYPE)) {
    				Log.i(TAG, "NUMBER: " + c.getString(3));
    				Log.i(TAG, "TYPE: " + c.getString(4));
    				Log.i(TAG, "LABEL: " + c.getString(5));
    				currentContact.setPhonenumber(c.getString(3));
    				if(Integer.valueOf(c.getString(4)) == Phone.TYPE_MAIN)
    					currentContact.setInfo("");
    				else
    					currentContact.setInfo(c.getString(5));
        			contacts.add(currentContact.copy());
        			Log.i(TAG, "c: " + currentContact);
    			}
    		}
    	} finally {
    		c.close();
    	}
		contacts.add(currentContact.copy());
		Log.i(TAG, "c: " + currentContact);    				
    	return contacts;
    }
    */
    /**
     * Returns the RawContact id for a sample SyncAdapter contact, or 0 if the
     * sample SyncAdapter user isn't found.
     * 
     * @param context the Authenticator Activity context
     * @param userId the sample SyncAdapter user ID to lookup
     * @return the RawContact id, or 0 if not found
     */
    private static long lookupRawContact(ContentResolver resolver, Uri rawContactUri, String DisplayName) {
        long authorId = 0;
        final Cursor c =
            resolver.query(rawContactUri, UserQuery.PROJECTION,
                UserQuery.SELECTION, new String[] {DisplayName},
                null);
        try {
            if (c.moveToFirst()) {
                authorId = c.getLong(UserQuery.COLUMN_ID);
            }
        } finally {
            if (c != null) {
                c.close();
            }
        }
        return authorId;
    }

    /**
     * Constants for a query to find a contact given DisplayName (saved in SOURCE_ID)
     */
    private interface UserQuery {
        public final static String[] PROJECTION =
            new String[] {RawContacts._ID};

        public final static int COLUMN_ID = 0;

        public static final String SELECTION =
            RawContacts.SOURCE_ID + "=?";
    }

}
