/*
 * Copyright (C) 2010 The Android Open Source Project
 * Copyright (C) 2011 Lars Bensmann
 *
 * This file is released under the GPLv2.
 */

package de.almosthappy.gssync.syncadapter;

import java.io.IOException;
import java.util.List;

import org.apache.http.ParseException;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SyncResult;
import android.os.Bundle;
import android.util.Log;
import de.almosthappy.gssync.Constants;
import de.almosthappy.gssync.client.Contact;
import de.almosthappy.gssync.client.GSSaxParser;
import de.almosthappy.gssync.platform.ContactManager;

/**
 * SyncAdapter implementation for syncing GS/* phonebook contacts to the
 * platform ContactOperations provider.
 */
public class SyncAdapter extends AbstractThreadedSyncAdapter {
    private static final String TAG = "SyncAdapter";

    private final AccountManager mAccountManager;
    private final Context mContext;

    public SyncAdapter(Context context, boolean autoInitialize) {
        super(context, autoInitialize);
        if(Constants.debug) {
        	Log.i(TAG, "SyncAdapter");
        }
        mContext = context;
        mAccountManager = AccountManager.get(context);
    }

    @Override
    public void onPerformSync(Account account, Bundle extras, String authority,
        ContentProviderClient provider, SyncResult syncResult) {
    	if(Constants.debug) {
    		Log.i(TAG, "onPerformSync");
    	}
    	String url;
        List<Contact> contacts;
        String authtoken = null;
         try {
             // use the account manager to request the credentials
        	 url = mAccountManager.getUserData(account, "URL");
        	 if(Constants.debug) {
        		 Log.i(TAG, "URL: " + url);
        		 Log.i(TAG, "Password: " + mAccountManager.getPassword(account));
        		 Log.i(TAG, "Account: " + account);
        	 }
             authtoken =
                mAccountManager.blockingGetAuthToken(account,
                    Constants.AUTHTOKEN_TYPE, true /* notifyAuthFailure */);
             if(Constants.debug) {
            	 Log.i(TAG, "authtoken: " + authtoken);
             }
             contacts = new GSSaxParser(url, account.name, authtoken).parse();
             if(Constants.debug) {
            	 Log.i(TAG, "contacts: " + contacts);
             }
             // update platform contacts.
             if(Constants.debug) {
            	 Log.d(TAG, "Calling contactManager's sync contacts");
             }
             ContactManager.syncContacts(mContext, account, contacts);
        } catch (final AuthenticatorException e) {
            syncResult.stats.numParseExceptions++;
            Log.e(TAG, "AuthenticatorException", e);
        } catch (final OperationCanceledException e) {
            Log.e(TAG, "OperationCanceledException", e);
        } catch (final IOException e) {
            Log.e(TAG, "IOException", e);
            syncResult.stats.numIoExceptions++;
 /*
        } catch (final AuthenticationException e) {
            mAccountManager.invalidateAuthToken(Constants.ACCOUNT_TYPE,
                authtoken);
            syncResult.stats.numAuthExceptions++;
            Log.e(TAG, "AuthenticationException", e);
*/
        } catch (final ParseException e) {
            syncResult.stats.numParseExceptions++;
            Log.e(TAG, "ParseException", e);
        }
    }
}
