/* pyid3lib: a python wrapper for the id3lib library for creating and
 * manipulating id3v1/v2 tags
 * Copyright 2000, 2003  Lars Bensmann (lars@almosthappy.de)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.

 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 * You can download this software from:
 * http://www.almosthappy.de/pyid3lib/
 */

#include "Python.h"

#include "id3.h"

typedef struct {
	char	*name;
	int	value;
} constantdata;

constantdata FieldIDConsts[] = {
	{ "FN_NOFIELD",	ID3FN_NOFIELD },
	{ "FN_TEXTENC",	ID3FN_TEXTENC },
	{ "FN_TEXT",	ID3FN_TEXT },
	{ "FN_URL",	ID3FN_URL },
	{ "FN_DATA",	ID3FN_DATA },
	{ "FN_DESCRIPTION",	ID3FN_DESCRIPTION },
	{ "FN_OWNER",	ID3FN_OWNER },
	{ "FN_EMAIL",	ID3FN_EMAIL },
	{ "FN_RATING",	ID3FN_RATING },
	{ "FN_FILENAME",	ID3FN_FILENAME },
	{ "FN_LANGUAGE",	ID3FN_LANGUAGE },
	{ "FN_PICTURETYPE",	ID3FN_PICTURETYPE },
	{ "FN_IMAGEFORMAT",	ID3FN_IMAGEFORMAT },
	{ "FN_MIMETYPE",	ID3FN_MIMETYPE },
	{ "FN_COUNTER",	ID3FN_COUNTER },
	{ "FN_ID",	ID3FN_ID },
	{ "FN_VOLUMEADJ",	ID3FN_VOLUMEADJ },
	{ "FN_NUMBITS",	ID3FN_NUMBITS },
	{ "FN_VOLCHGRIGHT",	ID3FN_VOLCHGRIGHT },
	{ "FN_VOLCHGLEFT",	ID3FN_VOLCHGLEFT },
	{ "FN_PEAKVOLRIGHT",	ID3FN_PEAKVOLRIGHT },
	{ "FN_PEAKVOLLEFT",	ID3FN_PEAKVOLLEFT },
	{ "FN_TIMESTAMPFORMAT",	ID3FN_TIMESTAMPFORMAT },
	{ "FN_CONTENTTYPE",	ID3FN_CONTENTTYPE },
	{ "FN_LASTFIELDID",	ID3FN_LASTFIELDID },
	{ NULL }
};

constantdata FrameIDConsts[] = {
	{ "FID_NOFRAME",	ID3FID_NOFRAME },
	{ "FID_AUDIOCRYPTO",	ID3FID_AUDIOCRYPTO },
	{ "FID_PICTURE",	ID3FID_PICTURE },
	{ "FID_COMMENT",	ID3FID_COMMENT },
	{ "FID_COMMERCIAL",	ID3FID_COMMERCIAL },
	{ "FID_CRYPTOREG",	ID3FID_CRYPTOREG },
	{ "FID_EQUALIZATION",	ID3FID_EQUALIZATION },
	{ "FID_EVENTTIMING",	ID3FID_EVENTTIMING },
	{ "FID_GENERALOBJECT",	ID3FID_GENERALOBJECT },
	{ "FID_GROUPINGREG",	ID3FID_GROUPINGREG },
	{ "FID_INVOLVEDPEOPLE",	ID3FID_INVOLVEDPEOPLE },
	{ "FID_LINKEDINFO",	ID3FID_LINKEDINFO },
	{ "FID_CDID",	ID3FID_CDID },
	{ "FID_MPEGLOOKUP",	ID3FID_MPEGLOOKUP },
	{ "FID_OWNERSHIP",	ID3FID_OWNERSHIP },
	{ "FID_PRIVATE",	ID3FID_PRIVATE },
	{ "FID_PLAYCOUNTER",	ID3FID_PLAYCOUNTER },
	{ "FID_POPULARIMETER",	ID3FID_POPULARIMETER },
	{ "FID_POSITIONSYNC",	ID3FID_POSITIONSYNC },
	{ "FID_BUFFERSIZE",	ID3FID_BUFFERSIZE },
	{ "FID_VOLUMEADJ",	ID3FID_VOLUMEADJ },
	{ "FID_REVERB",	ID3FID_REVERB },
	{ "FID_SYNCEDLYRICS",	ID3FID_SYNCEDLYRICS },
	{ "FID_SYNCEDTEMPO",	ID3FID_SYNCEDTEMPO },
	{ "FID_ALBUM",	ID3FID_ALBUM },
	{ "FID_BPM",	ID3FID_BPM },
	{ "FID_COMPOSER",	ID3FID_COMPOSER },
	{ "FID_CONTENTTYPE",	ID3FID_CONTENTTYPE },
	{ "FID_COPYRIGHT",	ID3FID_COPYRIGHT },
	{ "FID_DATE",	ID3FID_DATE },
	{ "FID_PLAYLISTDELAY",	ID3FID_PLAYLISTDELAY },
	{ "FID_ENCODEDBY",	ID3FID_ENCODEDBY },
	{ "FID_LYRICIST",	ID3FID_LYRICIST },
	{ "FID_FILETYPE",	ID3FID_FILETYPE },
	{ "FID_TIME",	ID3FID_TIME },
	{ "FID_CONTENTGROUP",	ID3FID_CONTENTGROUP },
	{ "FID_TITLE",	ID3FID_TITLE },
	{ "FID_SUBTITLE",	ID3FID_SUBTITLE },
	{ "FID_INITIALKEY",	ID3FID_INITIALKEY },
	{ "FID_LANGUAGE",	ID3FID_LANGUAGE },
	{ "FID_SONGLEN",	ID3FID_SONGLEN },
	{ "FID_MEDIATYPE",	ID3FID_MEDIATYPE },
	{ "FID_ORIGALBUM",	ID3FID_ORIGALBUM },
	{ "FID_ORIGFILENAME",	ID3FID_ORIGFILENAME },
	{ "FID_ORIGLYRICIST",	ID3FID_ORIGLYRICIST },
	{ "FID_ORIGARTIST",	ID3FID_ORIGARTIST },
	{ "FID_ORIGYEAR",	ID3FID_ORIGYEAR },
	{ "FID_FILEOWNER",	ID3FID_FILEOWNER },
	{ "FID_LEADARTIST",	ID3FID_LEADARTIST },
	{ "FID_BAND",	ID3FID_BAND },
	{ "FID_CONDUCTOR",	ID3FID_CONDUCTOR },
	{ "FID_MIXARTIST",	ID3FID_MIXARTIST },
	{ "FID_PARTINSET",	ID3FID_PARTINSET },
	{ "FID_PUBLISHER",	ID3FID_PUBLISHER },
	{ "FID_TRACKNUM",	ID3FID_TRACKNUM },
	{ "FID_RECORDINGDATES",	ID3FID_RECORDINGDATES },
	{ "FID_NETRADIOSTATION",	ID3FID_NETRADIOSTATION },
	{ "FID_NETRADIOOWNER",	ID3FID_NETRADIOOWNER },
	{ "FID_SIZE",	ID3FID_SIZE },
	{ "FID_ISRC",	ID3FID_ISRC },
	{ "FID_ENCODERSETTINGS",	ID3FID_ENCODERSETTINGS },
	{ "FID_USERTEXT",	ID3FID_USERTEXT },
	{ "FID_YEAR",	ID3FID_YEAR },
	{ "FID_UNIQUEFILEID",	ID3FID_UNIQUEFILEID },
	{ "FID_TERMSOFUSE",	ID3FID_TERMSOFUSE },
	{ "FID_UNSYNCEDLYRICS",	ID3FID_UNSYNCEDLYRICS },
	{ "FID_WWWCOMMERCIALINFO",	ID3FID_WWWCOMMERCIALINFO },
	{ "FID_WWWCOPYRIGHT",	ID3FID_WWWCOPYRIGHT },
	{ "FID_WWWAUDIOFILE",	ID3FID_WWWAUDIOFILE },
	{ "FID_WWWARTIST",	ID3FID_WWWARTIST },
	{ "FID_WWWAUDIOSOURCE",	ID3FID_WWWAUDIOSOURCE },
	{ "FID_WWWRADIOPAGE",	ID3FID_WWWRADIOPAGE },
	{ "FID_WWWPAYMENT",	ID3FID_WWWPAYMENT },
	{ "FID_WWWPUBLISHER",	ID3FID_WWWPUBLISHER },
	{ "FID_WWWUSER",	ID3FID_WWWUSER },
	{ "FID_METACRYPTO",	ID3FID_METACRYPTO },
	{ "FID_METACOMPRESSION",	ID3FID_METACOMPRESSION },
	{ NULL }
};

constantdata TagTypeConsts[] = {
	{ "TT_NONE",	ID3TT_NONE },
	{ "TT_ID3V1",	ID3TT_ID3V1 },
	{ "TT_ID3V2",	ID3TT_ID3V2 },
	{ "TT_LYRICS3",	ID3TT_LYRICS3 },
	{ "TT_LYRICS3V2",	ID3TT_LYRICS3V2 },
	{ "TT_MUSICMATCH",	ID3TT_MUSICMATCH },
	{ "TT_LYRICS",	ID3TT_LYRICS },
	{ "TT_ID3",	ID3TT_ID3 },
	{ "TT_ALL",	ID3TT_ALL },
	{ "TT_PREPENDED",	ID3TT_PREPENDED },
	{ "TT_APPENDED",	ID3TT_APPENDED },
	{ NULL }
};

void buildconstants(PyObject *d, constantdata *arrayname) {
	PyObject *Object;
	int i = 0;

	while(arrayname[i].name) {
		Object = Py_BuildValue("i", arrayname[i].value);
		PyDict_SetItemString(d, arrayname[i].name, Object);
		i++;
	}
}

void initconstants(PyObject *d)
{
	PyObject *Object;

	int i = 0;

	//buildconstants(d, &ContentTypeConsts);
	//buildconstants(d, &ErrConsts);
	//buildconstants(d, &FieldFlagsConsts);
	buildconstants(d, FieldIDConsts);
	//buildconstants(d, FieldTypeConsts);
	buildconstants(d, FrameIDConsts);
	buildconstants(d, TagTypeConsts);
	//buildconstants(d, &TextEncConsts);
	//buildconstants(d, &TimeStampFormatConsts);
	//buildconstants(d, &V1LengthsConsts);
	//buildconstants(d, &V1SpecConsts);
	//buildconstants(d, &V2SpecConsts);
}
