/* pyid3lib: a python wrapper for the id3lib library for creating and
 * manipulating id3v1/v2 tags
 * Copyright 2000, 2003  Lars Bensmann (lars@almosthappy.de)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.

 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 * You can download this software from:
 * http://www.almosthappy.de/pyid3lib/
 */

/******************************************************************************
* INSTANCE METHODS
******************************************************************************/

static PyObject * field_Get(PyObject *selfdummy, PyObject *args) {				/* field.Get(len) */
	fieldobject *self;
	int length;
	char *string;
	PyObject *stringobj;

	self = (fieldobject *)selfdummy;
	if (!PyArg_ParseTuple(args, "i", &length))
		return NULL;

	string = (char *)malloc(length);
	self->field->Get(string, length);

	stringobj = Py_BuildValue("s", string);
	free(string);
	return (PyObject *)stringobj;
}

static struct PyMethodDef field_methods[] = {
 { "Get",	field_Get,	1 },
 { NULL,	NULL }
};

/*
 * vim:ts=4
 */
