/* pyid3lib: a python wrapper for the id3lib library for creating and
 * manipulating id3v1/v2 tags
 * Copyright 2000, 2003  Lars Bensmann (lars@almosthappy.de)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.

 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 * You can download this software from:
 * http://www.almosthappy.de/pyid3lib/
 */

/******************************************************************************
* BASIC TYPE-OPERATIONS
******************************************************************************/

static frameobject* newframeobject() {
	frameobject *self;
	self = PyObject_NEW(frameobject, &Frametype);	/* malloc, init, incref */
	if (self == NULL)
		return NULL;	/* raise exception */
	
	self->frame = new ID3_Frame;

	return self;
}

static PyObject* frame_getattr(frameobject* self, char *name) { /* on instance.attr */
	return Py_FindMethod(frame_methods, (PyObject *)self, name);
}

static void frame_dealloc(frameobject *self) {
	PyMem_DEL(self);
}

/*
 * vim:ts=4
 */
