/* pyid3lib: a python wrapper for the id3lib library for creating and
 * manipulating id3v1/v2 tags
 * Copyright 2000, 2003  Lars Bensmann (lars@almosthappy.de)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.

 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 * You can download this software from:
 * http://www.almosthappy.de/pyid3lib/
 */

/******************************************************************************
* TYPE INFORMATION
******************************************************************************/

typedef struct {
	PyObject_HEAD
	ID3_Frame *frame;
} frameobject;

static void frame_dealloc(frameobject *self);
static PyObject* frame_getattr(frameobject* self, char *name);
static frameobject* newframeobject();

static PyTypeObject Frametype = {		/* main python type-descriptor */
	PyObject_HEAD_INIT(&PyType_Type)
	0,								/* ob_size */
	"ID3Frame",						/* tp_name */
	sizeof(frameobject),			/* tp_basicsize */
	0,								/* tp_itemsize */

/* standard methods */
	(destructor)	frame_dealloc,	/* tp_dealloc	ref-count = 0 */
	(printfunc)		0,				/* tp_print		print x */
	(getattrfunc)	frame_getattr,	/* tp_getattr	x.attr	*/
	(setattrfunc)	0,				/* tp_setattr	x.attr = y */
	(cmpfunc)		0,				/* tp_compare	x > y */
	(reprfunc)		0,				/* tp_repr		x, print x */

/* type categories */
	0,								/* tp_as_number	+,-,*,/,%,&,>>,pow...*/
	0,								/* tp_as_sequence +,[i],[i:j],len,...*/
	0,								/* tp_as_mapping [key], len,...*/

/* more methods */
	(hashfunc)		0,				/* tp_hash		dict[x] */
	(ternaryfunc)	0,				/* tp_call		x() */
	(reprfunc)		0,				/* tp_str		str(x) */
}; /* plus others */

#define is_frameobject(v) ((v)->ob_type == &Frametype)

/*
 * vim:ts=4
 */
