#!/usr/bin/python
"""
/* pyid3lib: a python wrapper for the id3lib library for creating and
 * manipulating id3v1/v2 tags
 * Copyright 2000, 2003  Lars Bensmann (lars@almosthappy.de)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.

 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 * You can download this software from:
 * http://www.almosthappy.de/pyid3lib/
 */
"""

import sys
import libid3

file = sys.argv[1]

frame = libid3.Frame()

tag=libid3.Tag()
print tag
print "Size():", tag.Size()
print "tag.Link(file):", tag.Link(file)
print "Size():", tag.Size()
print "Clear()"
tag.Clear()
print "Size():", tag.Size()
print "HasChanged():", tag.HasChanged()
print "SetUnsync(false):", tag.SetUnsync(0)
print "SetExtendedHeader(false):", tag.SetExtendedHeader(0)
print "SetPadding(true):", tag.SetPadding(1)
frame = libid3.Frame()
print "AddFrame(frame):", tag.AddFrame(frame)
#print "AddFrames(frame):", tag.AddFrames(frame)
frame2 = libid3.Frame()
print "AttachFrame(frame):", tag.AttachFrame(frame)

#print "Strip():", tag.Strip()
#print "Update():", tag.Update()

frame = tag.Find(libid3.FID_TITLE)
print "tag.Find(FID_TITLE):", frame
field = frame.Field(libid3.FN_TEXT)
print "frame.Field(FN_TEXT):", field
print "field.Get(1024):", field.Get(1024)

print libid3.Tag(file).Find(libid3.FID_TITLE).Field(libid3.FN_TEXT).Get(1024)
