/* pyid3lib: a python wrapper for the id3lib library for creating and
 * manipulating id3v1/v2 tags
 * Copyright 2000, 2003  Lars Bensmann (lars@almosthappy.de)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.

 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 * You can download this software from:
 * http://www.almosthappy.de/pyid3lib/
 */

/*****************************************************
 * libid3.cpp: Python-wrapper for libid3
 *****************************************************/

#include "Python.h"             /* Python header files */

#include "id3.h"
#include "id3/tag.h"

#include "constants.h"

static PyObject *ErrorObject;   /* locally-raised exception */

#define onError(message) \
       { PyErr_SetString(ErrorObject, message); return NULL; }

/**************************************
* TYPE INFORMATION
**************************************/

#include "tag-info.cc"
#include "frame-info.cc"
#include "field-info.cc"

/**************************************
* INSTANCE METHODS
**************************************/

#include "tag-instance-methods.cc"
#include "frame-instance-methods.cc"
#include "field-instance-methods.cc"

/**************************************
* BASIC TYPE-OPERATIONS
**************************************/

#include "tag-basic-type-ops.cc"
#include "frame-basic-type-ops.cc"
#include "field-basic-type-ops.cc"

/**************************************
* SEQUENCE TYPE-OPERATIONS
**************************************/

#include "tag-sequence-type-ops.cc"
#include "frame-sequence-type-ops.cc"
#include "field-sequence-type-ops.cc"

/******************************************************************************
* MODULE LOGIC
******************************************************************************/

static PyObject* tagtype_new(PyObject *self, PyObject *args) {
	char* filename;

	if (PyArg_ParseTuple(args, ""))
		return (PyObject *)newtagobject();

	if (PyArg_ParseTuple(args, "s", &filename))
		return (PyObject *)newtagobject(filename);

	return NULL;
}

static PyObject* frametype_new(PyObject *self, PyObject *args) {
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return (PyObject *)newframeobject();
}

static PyObject* fieldtype_new(PyObject *self, PyObject *args) {
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return (PyObject *)newfieldobject();
}

static struct PyMethodDef libid3_methods[] = {
	{ "Tag",	tagtype_new,	1 },	/* make a tag */
	{ "Frame",	frametype_new,	1 },	/* make a frame */
	{ "Field",	fieldtype_new,	1 },	/* make a field */
	{ NULL,		NULL }
};


extern "C" void initlibid3(void)
{
    PyObject *m, *d;

    /* create the module and add the functions */
    m = Py_InitModule("libid3", libid3_methods);        /* registration hook */

    /* add symbolic constants to the module */
    d = PyModule_GetDict(m);
    ErrorObject = Py_BuildValue("s", "libid3.error");  /* export exception */
    PyDict_SetItemString(d, "error", ErrorObject);       /* add more if need */

	initconstants(d);									/* add constants */
    
    /* check for errors */
    if (PyErr_Occurred())
        Py_FatalError("can't initialize module libid3");
}

/*
 * vim:ts=4
 */
