#!/usr/bin/python
"""
/* mp32ogg.py: convert mp3s to oggs
 * Copyright 2000, 2003  Lars Bensmann (lars@almosthappy.de)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.

 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 * You can download this software from:
 * http://www.almosthappy.de/pyid3lib/
 */
"""

import sys, os, string
import string
import ogg.vorbis
import libid3

version = "mp32ogg.py, version 0.0.1"

verbose = 1
test = 0
delete = 0

usage_str = '''
Usage: mp32ogg.py [options] files

-h, --help                     This output
-V, --version                  Version information
-v, --verbose                  Give verbose output
-d, --delete                   Delete mp3 file after successful conversion
-q, --quiet                    Shut up
-t, --test                     Don't do anything
-f, --force                    Force conversion, even if it is no MP3
'''
#--test                     Don't do anything

def gettag(tag, tagid):
    try:
        return tag.Find(tagid).Field(libid3.FN_TEXT).Get(1024)
    except AttributeError:
        return None

def convert(file, delete):
    tag = libid3.Tag()
    tag.Link(file)

    artist = gettag(tag, libid3.FID_LEADARTIST)
    title = gettag(tag, libid3.FID_TITLE)
    album = gettag(tag, libid3.FID_ALBUM)
    year = gettag(tag, libid3.FID_YEAR)
    track = gettag(tag, libid3.FID_TRACKNUM)
    comment = gettag(tag, libid3.FID_COMMENT)
    genre = gettag(tag, libid3.FID_CONTENTTYPE)

    if verbose > 1:
        print "Artist:", artist
        print "Title:", title
        print "Album:", album
        print "Year:", year
        print "Track:", track
        print "Comment:", comment
        print "Genre:", genre

    #wavfile = os.path.basename(file) + ".wav"
    #oggfile = os.path.basename(file) + ".ogg"
    wavfile = file + ".wav"
    oggfile = file + ".ogg"

    ret = 0
    if verbose:
        print "Erstelle Wav-Datei..."
    if verbose > 1:
        #command = 'mpg123 -w "%s" "%s"' % (wavfile, file)
        command = 'mpg123 -w - "%s"' % file
        print command
    else:
        #command = 'mpg123 -w "%s" "%s" 2> /dev/null' % (wavfile, file)
        command = 'mpg123 -w - "%s" 2> /dev/null' % file

    """
    if not test:
        ret = os.system(command)
        if ret != 0:
            print "Konnte '%s' nicht in eine Wav-Datei umwandeln." % file
            return
    """

    #oggcommand = 'oggenc -q3 -o "%s"' % oggfile
    oggcommand = 'oggenc -q3 -o "%s"' % oggfile
    if artist != None:
        oggcommand += ' -a "%s"' % artist
    if title != None:
        oggcommand += ' -t "%s"' % title
    if album != None:
        oggcommand += ' -l "%s"' % album.replace('\"', '\\"')
    if year != None:
        oggcommand += ' -d "%s"' % year
    if track != None:
        oggcommand += ' -N "%s"' % track
    if comment != None:
        oggcommand += ' -c "COMMENT=%s"' % comment
    if genre != None:
        oggcommand += ' -G "%s"' % genre
    if verbose > 1:
        #print '%s "%s"' % (oggcommand, wavfile)
        print '%s -' % oggcommand
    if not test:
        #ret = os.system('%s "%s"' % (oggcommand, wavfile))
        ret = os.system('%s | %s -' % (command, oggcommand))
        if ret != 0:
            #print "ERROR: Konnte '%s' nicht in eine Ogg-Datei umwandeln." % wavfile
            print "ERROR: Konnte '%s' nicht in eine Ogg-Datei umwandeln." % file
            return

        try:
            vf = ogg.vorbis.VorbisFile(oggfile)
        except ogg.vorbis.VorbisError:
            print "ERROR: %s: Fehler in der erstellten Datei." % oggfile
            return

        if verbose > 1:
            vc = vf.comment()
            print vc.items()

        #os.unlink(wavfile)

        if delete:
            os.unlink(file)


def usage():
    print version
    print usage_str

def main():
    global verbose, test
    import getopt

    os.umask(0002)
    args = sys.argv[1:]

    opts = 'hVvqtdf'
    long_opts = ('help', 'version', 'verbose', 'quiet', 'test', 'delete', 'force')
    delete = 0
    force = 0

    try:
        optlist, args = getopt.getopt(args, opts, long_opts)
    except getopt.error, m:
        print m
        print
        usage()
        sys.exit(2)
    
    for arg, val in optlist:
        if arg == '-h' or arg == '--help':
            usage()
            sys.exit(2)
            
        elif arg == '-V' or arg == '--version':
            print version
            sys.exit(0)

        elif arg == '-v' or arg == '--verbose':
            verbose += 1

        elif arg == '-q' or arg == '--quiet':
            verbose = 0

        elif arg == '-t' or arg == '--test':
            test = 1

        elif arg == '-d' or arg == '--delete':
            delete = 1

        elif arg == '-f' or arg == '--force':
            force = 1

    if len(args) == 0:
        usage()
        sys.exit(0)

    for file in args:
        if verbose > 1:
            print "%s:" % file
        extension = string.lower(file[string.rfind(file, '.'):])
        if extension != '.mp3':
            if force > 0:
                if verbose > 0:
                    print "INFO: Wrong extension '" + file + "'. Converting anyway."
            else:
                if verbose > 0:
                    print "WARNING: Wrong extension '" + file + "'. File skipped"
                continue
        convert(file, delete)

if __name__ == '__main__':
    main()

# vim:ts=4:et:sw=4
